/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPFunctionTemplate
extends CPPTemplateDefinition
implements ICPPFunctionTemplate,
ICPPInternalFunction {
    protected ICPPFunctionType declaredType;
    protected ICPPFunctionType type;

    public CPPFunctionTemplate(IASTName name) {
        super(name);
    }

    @Override
    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTDeclarator fdecl = this.getDeclaratorByName(node);
        if (fdecl instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)fdecl);
            super.addDefinition(node);
        }
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTDeclarator fdecl = this.getDeclaratorByName(node);
        if (fdecl == null) {
            return;
        }
        if (fdecl instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)fdecl);
        }
        super.addDeclaration(node);
    }

    private ICPPASTFunctionDeclarator getFirstFunctionDtor() {
        IASTDeclarator dtor = this.getDeclaratorByName(this.getDefinition());
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            return (ICPPASTFunctionDeclarator)dtor;
        }
        IASTNode[] decls = this.getDeclarations();
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode decl = iASTNodeArray[n2];
                dtor = this.getDeclaratorByName(decl);
                if (dtor instanceof ICPPASTFunctionDeclarator) {
                    return (ICPPASTFunctionDeclarator)dtor;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public ICPPParameter[] getParameters() {
        IASTNode[] decls;
        ICPPASTFunctionDeclarator declarator = null;
        IASTDeclarator dtor = this.getDeclaratorByName(this.getDefinition());
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            declarator = (ICPPASTFunctionDeclarator)dtor;
        }
        if ((decls = this.getDeclarations()) != null) {
            int defaultValuePosition = -1;
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode decl = iASTNodeArray[n2];
                dtor = this.getDeclaratorByName(decl);
                if (dtor instanceof ICPPASTFunctionDeclarator) {
                    if (declarator == null) {
                        declarator = (ICPPASTFunctionDeclarator)dtor;
                    } else {
                        int pos;
                        ICPPASTFunctionDeclarator contender = (ICPPASTFunctionDeclarator)dtor;
                        if (defaultValuePosition < 0) {
                            defaultValuePosition = CPPFunction.findFirstDefaultValue(declarator.getParameters());
                        }
                        if ((pos = CPPFunction.findFirstDefaultValue(contender.getParameters())) < defaultValuePosition) {
                            declarator = contender;
                            defaultValuePosition = pos;
                        }
                    }
                }
                ++n2;
            }
        }
        if (declarator != null) {
            ICPPASTParameterDeclaration[] params = declarator.getParameters();
            int size = params.length;
            if (size == 0) {
                return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
            }
            ICPPParameter[] result = new ICPPParameter[size];
            int i = 0;
            while (i < size) {
                ICPPASTParameterDeclaration param = params[i];
                IASTName pname = ASTQueries.findInnermostDeclarator(param.getDeclarator()).getName();
                IBinding binding = pname.resolveBinding();
                result[i] = binding instanceof ICPPParameter ? (ICPPParameter)binding : new CPPParameter.CPPParameterProblem(param, 5, pname.toCharArray());
                ++i;
            }
            if (result.length == 1 && SemanticUtil.isVoidType(result[0].getType())) {
                return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
            }
            return result;
        }
        return CPPBuiltinParameter.createParameterList(this.getType());
    }

    @Override
    public int getRequiredArgumentCount() {
        return CPPFunction.getRequiredArgumentCount(this.getParameters());
    }

    @Override
    public boolean hasParameterPack() {
        ICPPParameter[] pars = this.getParameters();
        return pars.length > 0 && pars[pars.length - 1].isParameterPack();
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPFunctionType getDeclaredType() {
        if (this.declaredType == null) {
            IASTName name = this.getTemplateName();
            IASTNode parent = name.getParent();
            while (parent.getParent() instanceof IASTDeclarator) {
                parent = parent.getParent();
            }
            IType t = CPPVisitor.createType((IASTDeclarator)parent, 0);
            this.declaredType = CPPFunction.toFunctionType(t);
        }
        return this.declaredType;
    }

    @Override
    public ICPPFunctionType getType() {
        if (this.type == null) {
            IASTName name = this.getTemplateName();
            IASTNode parent = name.getParent();
            while (parent.getParent() instanceof IASTDeclarator) {
                parent = parent.getParent();
            }
            IType t = CPPVisitor.createType((IASTDeclarator)parent);
            this.type = CPPFunction.toFunctionType(t);
        }
        return this.type;
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (parent != null && !(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            ICPPASTDeclSpecifier declSpec = this.getDeclSpecifier((IASTDeclaration)parent);
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    protected ICPPASTDeclSpecifier getDeclSpecifier(IASTDeclaration decl) {
        if (decl instanceof IASTSimpleDeclaration) {
            return (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
        }
        if (decl instanceof IASTFunctionDefinition) {
            return (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier();
        }
        return null;
    }

    @Override
    public IBinding resolveParameter(CPPParameter param) {
        int pos = param.getParameterPosition();
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen) {
            block4: {
                ICPPASTParameterDeclaration[] params;
                IASTDeclarator tdecl;
                block3: {
                    block2: {
                        if (i >= 0) break block2;
                        tdecl = this.getDeclaratorByName(this.getDefinition());
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = this.getDeclaratorByName(decls[i])) == null) break;
                }
                if (tdecl instanceof ICPPASTFunctionDeclarator && pos < (params = ((ICPPASTFunctionDeclarator)tdecl).getParameters()).length) {
                    IASTName oName = this.getParamName(params[pos]);
                    return oName.resolvePreBinding();
                }
            }
            ++i;
        }
        return param;
    }

    protected void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        ICPPASTParameterDeclaration[] updateParams = fdtor.getParameters();
        int k = 0;
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block5: {
                IASTDeclarator tdecl;
                block4: {
                    block3: {
                        if (i >= 0) break block3;
                        tdecl = this.getDeclaratorByName(this.getDefinition());
                        if (tdecl != null) break block4;
                        break block5;
                    }
                    if (decls == null || (tdecl = this.getDeclaratorByName(decls[i])) == null) break;
                }
                if (tdecl instanceof ICPPASTFunctionDeclarator) {
                    ICPPASTParameterDeclaration[] params = ((ICPPASTFunctionDeclarator)tdecl).getParameters();
                    int end = Math.min(params.length, updateParams.length);
                    while (k < end) {
                        IASTName oName = this.getParamName(params[k]);
                        IBinding b = oName.resolvePreBinding();
                        IASTName n = this.getParamName(updateParams[k]);
                        n.setBinding(b);
                        ASTInternal.addDeclaration(b, n);
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    @Override
    public final boolean isStatic() {
        return this.isStatic(true);
    }

    @Override
    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    @Override
    public boolean isInline() {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (parent != null && !(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            ICPPASTDeclSpecifier declSpec = this.getDeclSpecifier((IASTDeclaration)parent);
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    @Override
    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isConstexpr() {
        ICPPASTFunctionDefinition functionDefinition = CPPFunction.getFunctionDefinition(this.getDefinition());
        if (functionDefinition == null) {
            return false;
        }
        return ((ICPPASTDeclSpecifier)functionDefinition.getDeclSpecifier()).isConstexpr();
    }

    @Override
    public boolean isDeleted() {
        return CPPFunction.isDeletedDefinition(this.getDefinition());
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    @Override
    public boolean takesVarArgs() {
        ICPPASTFunctionDeclarator fdecl = this.getFirstFunctionDtor();
        if (fdecl != null) {
            return fdecl.takesVarArgs();
        }
        return false;
    }

    @Override
    public boolean isNoReturn() {
        return CPPFunction.isNoReturn(this.getFirstFunctionDtor());
    }

    private IASTDeclarator getDeclaratorByName(IASTNode node) {
        while (node != null) {
            if (!((node = node.getParent()) instanceof IASTDeclarator)) continue;
            return ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node);
        }
        return null;
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        return this.hasStorageClass(3);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        return result.toString();
    }

    @Override
    public IType[] getExceptionSpecification() {
        ICPPASTFunctionDeclarator declarator = this.getFirstFunctionDtor();
        if (declarator != null) {
            IASTTypeId[] typeIds = declarator.getExceptionSpecification();
            if (typeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (typeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] types = new IType[typeIds.length];
            int i = 0;
            while (i < typeIds.length) {
                types[i] = CPPVisitor.createType(typeIds[i]);
                ++i;
            }
            return types;
        }
        return null;
    }

    @Override
    public ICPPExecution getFunctionBodyExecution() {
        if (!this.isConstexpr()) {
            return null;
        }
        return CPPFunction.computeFunctionBodyExecution(this.getDefinition());
    }
}

