/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.parsers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.editors.TmfTableColumnUtils;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.PlatformUI;

public class CustomParserUtils {
    private CustomParserUtils() {
    }

    public static void cleanup(final @NonNull String traceTypeId) {
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TmfProjectElement projectElement;
                    TmfTraceFolder tracesFolder;
                    IProject project = iProjectArray[n2];
                    if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature") && (tracesFolder = (projectElement = TmfProjectRegistry.getProject(project, true)).getTracesFolder()) != null) {
                        for (TmfTraceElement trace : tracesFolder.getTraces()) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (!traceTypeId.equals(trace.getTraceType())) continue;
                            Display.getDefault().syncExec(trace::closeEditors);
                            trace.deleteSupplementaryResources();
                            trace.refreshSupplementaryFolder();
                        }
                    }
                    ++n2;
                }
                TmfTableColumnUtils.clearColumnOrder(traceTypeId);
                TmfTableColumnUtils.clearColumnWidth(traceTypeId);
                TmfTableColumnUtils.clearColumnResizable(traceTypeId);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
        }
    }
}

