/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;

class ReferenceAnalyzer
extends MoveStaticMemberAnalyzer {
    public ReferenceAnalyzer(CompilationUnitRewrite cuRewrite, IBinding[] members, ITypeBinding target, ITypeBinding source) {
        super(cuRewrite, members, source, target);
    }

    public boolean needsTargetImport() {
        return this.fNeedsImport;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding != null && this.isMovedMember((IBinding)(binding = binding.getTypeDeclaration()))) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        VariableDeclarationFragment singleFragment = (VariableDeclarationFragment)node.fragments().get(0);
        if (this.isMovedMember((IBinding)singleFragment.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FunctionDeclaration node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        if (!node.isDeclaration() && this.isMovedMember(node.resolveBinding()) && !this.isProcessed((ASTNode)node)) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }

    public boolean visit(QualifiedName node) {
        if (this.isMovedMember(node.resolveBinding())) {
            if (node.getParent() instanceof ImportDeclaration) {
                ITypeBinding typeBinding = node.resolveTypeBinding();
                if (typeBinding != null) {
                    this.fCuRewrite.getImportRewrite().removeImport(typeBinding.getQualifiedName());
                }
                String imp = this.fCuRewrite.getImportRewrite().addImport(String.valueOf(this.fTarget.getQualifiedName()) + '.' + node.getName().getIdentifier());
                this.fCuRewrite.getImportRemover().registerAddedImport(imp);
            } else {
                this.rewrite(node, this.fTarget);
            }
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FieldAccess node) {
        if (this.isMovedMember((IBinding)node.resolveFieldBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return super.visit(node);
    }

    public boolean visit(FunctionInvocation node) {
        IFunctionBinding binding = node.resolveMethodBinding();
        if (binding != null && this.isMovedMember((IBinding)(binding = binding.getMethodDeclaration()))) {
            this.rewrite(node, this.fTarget);
        }
        return super.visit(node);
    }

    public boolean visit(MemberRef node) {
        if (this.isMovedMember(node.resolveBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }

    public boolean visit(FunctionRef node) {
        if (this.isMovedMember(node.resolveBinding())) {
            this.rewrite(node, this.fTarget);
        }
        return false;
    }
}

