/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeSynonymsPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public abstract class AbstractIndexer
implements IIndexConstants {
    SearchDocument document;

    public AbstractIndexer(SearchDocument document) {
        this.document = document;
    }

    public void addClassDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superclass, boolean secondary, char[][] synonyms) {
        this.addTypeDeclaration(modifiers, packageName, name, superclass);
        if (superclass != null) {
            this.addTypeReference(superclass);
        }
        char[] fullyQualifiedName = QualificationHelpers.createFullyQualifiedName(packageName, name);
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(fullyQualifiedName, superclass));
        if (synonyms != null && synonyms.length > 0) {
            this.addIndexEntry(TYPE_SYNONYMS, TypeSynonymsPattern.createIndexKey(fullyQualifiedName, synonyms));
        }
    }

    public void addConstructorDeclaration(char[] typeName, char[][] parameterTypes, char[][] parameterNames, int modifiers) {
        this.addIndexEntry(CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(typeName, parameterTypes, parameterNames, modifiers));
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (parameterTypes[i] != null) {
                    this.addTypeReference(parameterTypes[i]);
                }
                ++i;
            }
        }
    }

    public void addConstructorReference(char[] typeName, int argCount) {
        this.addTypeReference(typeName);
        this.addIndexEntry(CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(typeName, null, null, 0));
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName, char[] declaringType, int modifiers, boolean isVar) {
        if (fieldName != null && fieldName.length > 0) {
            char[] key = isVar ? VAR_DECL : FIELD_DECL;
            this.addIndexEntry(key, FieldPattern.createIndexKey(fieldName, typeName, declaringType != null ? declaringType : IIndexConstants.GLOBAL_SYMBOL, modifiers));
            if (typeName != null) {
                this.addTypeReference(typeName);
            }
        } else {
            String errorMsg = "JSDT AbstractIndexer attempted to index a field with no name, this should never happen.";
            if (typeName != null) {
                errorMsg = String.valueOf(errorMsg) + "\ntypeName: " + new String(typeName);
            }
            if (declaringType != null) {
                errorMsg = String.valueOf(errorMsg) + "\ndeclaringType: " + new String(declaringType);
            }
            Logger.log(2, errorMsg);
        }
    }

    public void addFieldReference(char[] fieldName) {
        this.addNameReference(fieldName);
    }

    protected void addIndexEntry(char[] category, char[] key) {
        this.document.addIndexEntry(category, key);
    }

    public void addMethodDeclaration(char[] methodName, char[][] parameterTypes, char[][] paramaterNames, char[] returnType, char[] declaringType, boolean isFunction, int modifiers) {
        char[] key = MethodPattern.createIndexKey(methodName, parameterTypes, paramaterNames, declaringType != null ? declaringType : IIndexConstants.GLOBAL_SYMBOL, returnType, modifiers);
        if (key != null) {
            this.addIndexEntry(isFunction ? FUNCTION_DECL : METHOD_DECL, key);
        }
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                this.addTypeReference(parameterTypes[i]);
                ++i;
            }
        }
        if (returnType != null) {
            this.addTypeReference(returnType);
        }
    }

    public void addMethodReference(char[] methodName) {
        char[] key = MethodPattern.createIndexKey(methodName);
        if (key != null) {
            this.addIndexEntry(METHOD_REF, key);
        }
    }

    public void addNameReference(char[] name) {
        this.addIndexEntry(REF, name);
    }

    protected void addTypeDeclaration(int modifiers, char[] qualification, char[] simpleTypeName, char[] superTypeName) {
        char[] indexKey = TypeDeclarationPattern.createIndexKey(qualification, simpleTypeName, new char[][]{superTypeName}, modifiers);
        this.addIndexEntry(TYPE_DECL, indexKey);
    }

    public void addTypeReference(char[] typeName) {
        if (typeName != null) {
            this.addNameReference(typeName);
        }
    }

    public abstract void indexDocument();
}

