/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.application;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.WebApplication;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Application
implements IApplication {
    private static final String WORKSPACE_NAME = ".tracecompass-webapp";
    private WebApplication fWebAppl = null;
    private Location fInstanceLoc = null;
    private IApplicationContext fAppContext = null;
    private Bundle fBundle;
    private @NonNull Object fResult = EXIT_OK;

    public Application() {
    }

    public Application(WebApplication webApp) {
        this.fWebAppl = webApp;
    }

    public Object start(IApplicationContext context) throws Exception {
        this.fAppContext = context;
        this.fInstanceLoc = Platform.getInstanceLocation();
        Bundle bundle = this.fBundle = FrameworkUtil.getBundle(this.getClass());
        if (!this.fInstanceLoc.allowsDefault() && !this.fInstanceLoc.isSet()) {
            File workspaceRoot = new File(Application.getWorkspaceRoot());
            if (!workspaceRoot.exists()) {
                ExitCode exitCode = ExitCode.ERROR_NO_WORKSPACE_ROOT;
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), exitCode.getErrorText()));
                return exitCode.ordinal();
            }
            if (!workspaceRoot.canWrite()) {
                ExitCode exitCode = ExitCode.ERROR_WORKSPACE_ROOT_PERMISSION;
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), exitCode.getErrorText()));
                return exitCode.ordinal();
            }
            String workspace = String.valueOf(Application.getWorkspaceRoot()) + File.separator + WORKSPACE_NAME;
            this.fInstanceLoc.set(new URL("file", null, workspace), false);
        }
        if (!this.fInstanceLoc.lock()) {
            ExitCode exitCode = ExitCode.ERROR_WORKSPACE_ALREADY_IN_USE;
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), String.valueOf(exitCode.getErrorText()) + " (workspace: " + this.fInstanceLoc.getURL().getPath() + ")"));
            return exitCode.ordinal();
        }
        if (this.fWebAppl == null) {
            this.fWebAppl = new WebApplication();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Application.this.stop();
            }
        });
        try {
            this.fWebAppl.start();
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.ERROR_RUNNING_TRACE_SERVER;
            this.fResult = exitCode.ordinal();
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), exitCode.getErrorText(), (Throwable)e));
            return this.fResult;
        }
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
        WebApplication webAppl = this.fWebAppl;
        Bundle bundle = this.fBundle;
        IApplicationContext appContext = this.fAppContext;
        Location instanceLoc = this.fInstanceLoc;
        if (this.fResult.equals(EXIT_OK)) {
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundle.getSymbolicName(), "Shutting down trace server."));
            if (webAppl != null) {
                webAppl.dispose();
                webAppl.stop();
            }
            try {
                ResourcesPlugin.getWorkspace().save(true, null);
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), "Error saving workspace", (Throwable)e));
            }
            if (appContext != null) {
                appContext.setResult(this.fResult, (IApplication)this);
            }
        }
        if (instanceLoc != null) {
            instanceLoc.release();
        }
    }

    private static String getWorkspaceRoot() {
        String workspaceRoot = System.getenv().get("TRACING_SERVER_ROOT");
        if (workspaceRoot == null) {
            workspaceRoot = System.getProperty("user.home");
        }
        return workspaceRoot;
    }

    private static enum ExitCode {
        OK(""),
        ERROR_NO_WORKSPACE_ROOT("Trace server error: Workspace root doesn't exist."),
        ERROR_WORKSPACE_ROOT_PERMISSION("Trace server error: Workspace not writable."),
        ERROR_WORKSPACE_ALREADY_IN_USE("Trace server error: Workspace already in use."),
        ERROR_RUNNING_TRACE_SERVER("Trace server error: Error running trace server.");

        private @NonNull String fErrorText;

        private ExitCode(String errorText) {
            this.fErrorText = errorText;
        }

        public @NonNull String getErrorText() {
            return this.fErrorText;
        }
    }
}

