/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class TerminateAllAction
extends DebugCommandAction
implements ILaunchesListener2 {
    @Override
    protected ISelection getContext() {
        return new StructuredSelection((Object[])this.getLaunchManager().getLaunches());
    }

    @Override
    public void dispose() {
        this.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.dispose();
    }

    private void attachSelfToLaunchManager() {
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)this);
        this.setEnabled(this.canTerminate());
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.debug.ui.terminate_all_action_context";
    }

    @Override
    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.terminateAll";
    }

    @Override
    public String getText() {
        return ActionMessages.TerminateAllAction_2;
    }

    @Override
    public String getToolTipText() {
        return ActionMessages.TerminateAllAction_3;
    }

    @Override
    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_ALL");
    }

    @Override
    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_ALL");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_ALL");
    }

    protected Class<ITerminateHandler> getCommandType() {
        return ITerminateHandler.class;
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.setEnabled(this.canTerminate());
    }

    public void launchesAdded(ILaunch[] launches) {
        this.setEnabled(this.canTerminate());
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.setEnabled(this.canTerminate());
    }

    @Override
    public void init(IWorkbenchPart part) {
        super.init(part);
        this.attachSelfToLaunchManager();
    }

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.attachSelfToLaunchManager();
    }

    @Override
    protected boolean getInitialEnablement() {
        return this.canTerminate();
    }

    private boolean canTerminate() {
        return Arrays.stream(this.getLaunchManager().getLaunches()).anyMatch(ITerminate::canTerminate);
    }

    @Override
    public void runWithEvent(Event event) {
        ILaunch[] iLaunchArray = this.getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            try {
                if (l.canTerminate()) {
                    l.terminate();
                }
            }
            catch (DebugException e) {
                ILog.get().log((IStatus)Status.warning((String)("Unable to terminate launch: " + e.getMessage()), (Throwable)e));
            }
            ++n2;
        }
        this.setEnabled(this.canTerminate());
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        this.setEnabled(this.canTerminate());
    }
}

