/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IRegion;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    @Override
    public void add(IJavaScriptElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    @Override
    public boolean contains(IJavaScriptElement element) {
        int size = this.fRootElements.size();
        ArrayList parents = this.getAncestors(element);
        int i = 0;
        while (i < size) {
            IJavaScriptElement aTop = (IJavaScriptElement)this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int j = 0;
            int pSize = parents.size();
            while (j < pSize) {
                if (aTop.equals(parents.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ArrayList getAncestors(IJavaScriptElement element) {
        ArrayList<IJavaScriptElement> parents = new ArrayList<IJavaScriptElement>();
        IJavaScriptElement parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public IJavaScriptElement[] getElements() {
        int size = this.fRootElements.size();
        IJavaScriptElement[] roots = new IJavaScriptElement[size];
        int i = 0;
        while (i < size) {
            roots[i] = (IJavaScriptElement)this.fRootElements.get(i);
            ++i;
        }
        return roots;
    }

    @Override
    public boolean remove(IJavaScriptElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    protected void removeAllChildren(IJavaScriptElement element) {
        if (element instanceof IParent) {
            ArrayList<IJavaScriptElement> newRootElements = new ArrayList<IJavaScriptElement>();
            int i = 0;
            int size = this.fRootElements.size();
            while (i < size) {
                IJavaScriptElement currentRoot = (IJavaScriptElement)this.fRootElements.get(i);
                IJavaScriptElement parent = currentRoot.getParent();
                boolean isChild = false;
                while (parent != null) {
                    if (parent.equals(element)) {
                        isChild = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!isChild) {
                    newRootElements.add(currentRoot);
                }
                ++i;
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        IJavaScriptElement[] roots = this.getElements();
        buffer.append('[');
        int i = 0;
        while (i < roots.length) {
            buffer.append(roots[i].getElementName());
            if (i < roots.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

