/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;

public class EclipseEnvironmentSupplier
implements ICoreEnvironmentVariableSupplier {
    @Override
    public IEnvironmentVariable getVariable(String name, Object context) {
        if (context == null) {
            String value = EnvironmentReader.getEnvVar((String)name);
            if (value == null) {
                return null;
            }
            return new EnvironmentVariable(name, value, 1, null);
        }
        return null;
    }

    @Override
    public IEnvironmentVariable[] getVariables(Object context) {
        if (context == null) {
            Properties values = EnvironmentReader.getEnvVars();
            if (values == null) {
                return null;
            }
            IEnvironmentVariable[] variables = new IEnvironmentVariable[values.size()];
            Enumeration<?> en = values.propertyNames();
            int i = 0;
            while (i < variables.length) {
                String name = (String)en.nextElement();
                String value = values.getProperty(name);
                variables[i] = new EnvironmentVariable(name, value, 1, null);
                ++i;
            }
            return variables;
        }
        return null;
    }

    @Override
    public boolean appendEnvironment(Object context) {
        return true;
    }
}

