/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.tracecompass.incubator.internal.filters.core.Activator;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.LanguageFilterServer;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.FilterLspConfiguration;

public class FilterServerFactory {
    private LanguageFilterServer fLSPServer;
    private ServerSocket fServerSocket;
    private Thread fMainThread;
    private List<Thread> fClientThreads = new ArrayList<Thread>();
    private Boolean fCanRun = true;

    public FilterServerFactory() throws IOException {
        this.fServerSocket = new ServerSocket(FilterLspConfiguration.PORT);
        this.fMainThread = new Thread(new ServerLoop());
        this.fMainThread.start();
    }

    @VisibleForTesting
    public FilterServerFactory(InputStream in, OutputStream out) {
        this.fLSPServer = new LanguageFilterServer();
        Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)this.fLSPServer, (InputStream)in, (OutputStream)out);
        this.fLSPServer.connect((LanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public void dispose() {
        this.fClientThreads.forEach(t -> t.interrupt());
        this.fCanRun = false;
        this.fMainThread.interrupt();
    }

    class ConnectionInitializer
    implements Runnable {
        private Socket fClientSocket;

        ConnectionInitializer(Socket clientSocket) {
            this.fClientSocket = clientSocket;
        }

        @Override
        public void run() {
            try {
                InputStream in = this.fClientSocket.getInputStream();
                OutputStream out = this.fClientSocket.getOutputStream();
                FilterServerFactory.this.fLSPServer = new LanguageFilterServer();
                Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)FilterServerFactory.this.fLSPServer, (InputStream)in, (OutputStream)out);
                FilterServerFactory.this.fLSPServer.connect((LanguageClient)launcher.getRemoteProxy());
                launcher.startListening();
            }
            catch (IOException e) {
                try {
                    this.fClientSocket.close();
                }
                catch (IOException iOException) {}
                Activator.getInstance().logError(e.getMessage());
            }
        }
    }

    class ServerLoop
    implements Runnable {
        ServerLoop() {
        }

        @Override
        public void run() {
            while (FilterServerFactory.this.fCanRun.booleanValue()) {
                try {
                    Socket clientSocket = FilterServerFactory.this.fServerSocket.accept();
                    Thread thread = new Thread(new ConnectionInitializer(clientSocket));
                    FilterServerFactory.this.fClientThreads.add(thread);
                    thread.start();
                }
                catch (IOException e) {
                    Activator.getInstance().logError(e.getMessage());
                }
            }
            try {
                FilterServerFactory.this.fServerSocket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

