/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.tasks.TaskScanningScheduler;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.TabFolderLayout;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ExclusionsTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.MainTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.PropertyPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class TaskTagPreferencePage
extends PropertyPreferencePage {
    private static final boolean _debugPreferences = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.core/tasks/preferences"));
    private static final String TASK_TAG_LAST_TAB = "task-tag-last-tab";
    private int detectionRequested = 0;
    private Button fEnableCheckbox = null;
    private boolean fEnableTaskTags = true;
    private boolean fOriginalEnableTaskTags = true;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private Button fRedetectButton;
    private SelectionListener fTabEnablementListener;
    private TabFolder fTabFolder;
    private IPreferenceTab[] fTabs = null;

    protected void contributeButtons(Composite parent) {
        if (this.getElement() == null) {
            ((GridLayout)parent.getLayout()).numColumns += 2;
            this.fRedetectButton = new Button(parent, 8);
            this.fRedetectButton.setText(SSEUIMessages.TaskTagPreferencePage_32);
            this.fRedetectButton.setLayoutData((Object)new GridData(144));
            this.fRedetectButton.setEnabled(true);
            this.fRedetectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Job redetectJob = new Job(SSEUIMessages.TaskTagPreferenceTab_27){

                        public Object getAdapter(Class adapter) {
                            return null;
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            TaskScanningScheduler.refresh();
                            return Status.OK_STATUS;
                        }
                    };
                    redetectJob.schedule();
                }
            });
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)new GridData(132));
        }
        super.contributeButtons(parent);
    }

    @Override
    protected Control createCommonContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginLeft = 0;
        compositeLayout.marginRight = 0;
        composite.setLayout((Layout)compositeLayout);
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        this.fOriginalEnableTaskTags = this.fEnableTaskTags = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), "enabled", false, preferenceScopes);
        this.fEnableCheckbox = new Button(composite, 32);
        this.fEnableCheckbox.setSelection(this.fEnableTaskTags);
        this.fEnableCheckbox.setText(SSEUIMessages.TaskTagPreferenceTab_31);
        this.fEnableCheckbox.setSelection(this.fEnableTaskTags);
        this.fEnableCheckbox.setLayoutData((Object)new GridData(32, 8, false, false, 1, 1));
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setLayout((Layout)new TabFolderLayout());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem taskItem = new TabItem(this.fTabFolder, 0);
        MainTab mainTab = new MainTab(this, this.fPreferencesService, preferenceScopes);
        taskItem.setText(mainTab.getTitle());
        final Control taskTagsControl = mainTab.createContents((Composite)this.fTabFolder);
        taskItem.setControl(taskTagsControl);
        TabItem exclusionItem = new TabItem(this.fTabFolder, 0);
        ExclusionsTab exclusionsTab = new ExclusionsTab(this, this.fPreferencesService, preferenceScopes);
        exclusionItem.setText(exclusionsTab.getTitle());
        final Control exclusionControl = exclusionsTab.createContents((Composite)this.fTabFolder);
        exclusionItem.setControl(exclusionControl);
        this.fTabs = new IPreferenceTab[]{mainTab, exclusionsTab};
        this.fTabEnablementListener = new SelectionAdapter(){
            ControlEnableState[] lastEnableStates = null;

            public void widgetSelected(SelectionEvent e) {
                TaskTagPreferencePage.this.fEnableTaskTags = TaskTagPreferencePage.this.fEnableCheckbox.getSelection();
                if (TaskTagPreferencePage.this.fEnableTaskTags) {
                    if (this.lastEnableStates != null) {
                        int i = 0;
                        while (i < this.lastEnableStates.length) {
                            if (this.lastEnableStates[i] != null) {
                                this.lastEnableStates[i].restore();
                            }
                            ++i;
                        }
                        this.lastEnableStates = null;
                        TaskTagPreferencePage.this.fTabFolder.redraw();
                    }
                } else if (this.lastEnableStates == null) {
                    this.lastEnableStates = new ControlEnableState[TaskTagPreferencePage.this.fTabs.length + 1];
                    this.lastEnableStates[0] = ControlEnableState.disable((Control)taskTagsControl);
                    this.lastEnableStates[1] = ControlEnableState.disable((Control)exclusionControl);
                    if (TaskTagPreferencePage.this.fRedetectButton != null) {
                        this.lastEnableStates[2] = ControlEnableState.disable((Control)TaskTagPreferencePage.this.fRedetectButton);
                    }
                }
            }
        };
        this.fTabEnablementListener.widgetSelected(null);
        this.fEnableCheckbox.addSelectionListener(this.fTabEnablementListener);
        int activeTab = new DefaultScope().getNode(this.getPreferenceNodeQualifier()).getInt(TASK_TAG_LAST_TAB, 0);
        if (activeTab > 0) {
            this.fTabFolder.setSelection(activeTab);
        }
        SSEUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.sse.ui.webx0000");
        return composite;
    }

    @Override
    protected String getPreferenceNodeQualifier() {
        return "org.eclipse.wst.sse.core/task-tags";
    }

    @Override
    protected String getPreferencePageID() {
        return "org.eclipse.wst.sse.ui.preferences.tasktags";
    }

    @Override
    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    @Override
    protected String getPropertyPageID() {
        return "org.eclipse.wst.sse.ui.project.properties.tasktags";
    }

    public String getTitle() {
        return SSEUIMessages.TaskTagPreferenceTab_20;
    }

    public void init(IWorkbench workbench) {
    }

    public void performApply() {
        super.performApply();
        this.save();
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performApply();
            ++i;
        }
        this.promptForRedetectIfNecessary();
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        IEclipsePreferences defaultPreferences = this.createPreferenceScopes()[1].getNode(this.getPreferenceNodeQualifier());
        this.fEnableTaskTags = defaultPreferences.getBoolean("enabled", false);
        this.fEnableCheckbox.setSelection(this.fEnableTaskTags);
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performDefaults();
            ++i;
        }
        this.fTabEnablementListener.widgetSelected(null);
        if (_debugPreferences) {
            System.out.println("Loading defaults in " + ((Object)((Object)this)).getClass().getName());
        }
    }

    @Override
    public boolean performOk() {
        boolean ok = super.performOk();
        this.save();
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performOk();
            ++i;
        }
        this.promptForRedetectIfNecessary();
        new DefaultScope().getNode(this.getPreferenceNodeQualifier()).putInt(TASK_TAG_LAST_TAB, this.fTabFolder.getSelectionIndex());
        IScopeContext[] contexts = this.createPreferenceScopes();
        if (this.getProject() != null && !this.isElementSettingsEnabled()) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "use-project-settings" + " (" + true + ") in scope " + contexts[0].getName() + ":" + contexts[0].getLocation());
            }
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("use-project-settings");
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "ignored-contentTypes" + " (" + true + ") in scope " + contexts[0].getName() + ":" + contexts[0].getLocation());
            }
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("ignored-contentTypes");
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "taskPriorities" + " (" + true + ") in scope " + contexts[0].getName() + ":" + contexts[0].getLocation());
            }
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("taskPriorities");
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "taskTags" + " (" + true + ") in scope " + contexts[0].getName() + ":" + contexts[0].getLocation());
            }
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("taskTags");
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "enabled" + " (" + true + ") in scope " + contexts[0].getName() + ":" + contexts[0].getLocation());
            }
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("enabled");
        }
        int i2 = 0;
        while (i2 < contexts.length) {
            try {
                contexts[i2].getNode(this.getPreferenceNodeQualifier()).flush();
            }
            catch (BackingStoreException e) {
                Logger.logException("problem saving preference settings to scope " + contexts[i2].getName(), e);
            }
            ++i2;
        }
        return ok;
    }

    private void promptForRedetectIfNecessary() {
        if (this.detectionRequested > 0) {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), SSEUIMessages.TaskTagPreferenceTab_22, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getImage(), SSEUIMessages.TaskTagPreferenceTab_23, 3, new String[]{SSEUIMessages.TaskTagPreferenceTab_24, SSEUIMessages.TaskTagPreferenceTab_25, SSEUIMessages.TaskTagPreferenceTab_26}, 2);
            int button = dialog.open();
            if (button == 0) {
                Job redetectJob = new Job(SSEUIMessages.TaskTagPreferenceTab_27){

                    public Object getAdapter(Class adapter) {
                        return null;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        if (TaskTagPreferencePage.this.getProject() == null) {
                            if (_debugPreferences) {
                                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": rescanning all");
                            }
                            TaskScanningScheduler.refresh();
                        } else {
                            if (_debugPreferences) {
                                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": rescanning " + TaskTagPreferencePage.this.getProject());
                            }
                            TaskScanningScheduler.refresh((IProject)TaskTagPreferencePage.this.getProject());
                        }
                        return Status.OK_STATUS;
                    }
                };
                redetectJob.schedule(500L);
            }
            this.detectionRequested = 0;
        }
    }

    void requestRedetection() {
        ++this.detectionRequested;
    }

    private void save() {
        if (this.fEnableTaskTags != this.fOriginalEnableTaskTags) {
            this.requestRedetection();
        }
        this.fOriginalEnableTaskTags = this.fEnableTaskTags;
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        IEclipsePreferences defaultPreferences = preferenceScopes[1].getNode(this.getPreferenceNodeQualifier());
        boolean defaultEnable = defaultPreferences.getBoolean("enabled", false);
        if (this.fEnableTaskTags == defaultEnable) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "enabled" + " from scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
            }
            preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).remove("enabled");
        } else {
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " setting " + "enabled" + " \"" + this.fEnableTaskTags + "\" in scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
            }
            preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("enabled", this.fEnableTaskTags);
        }
        if (this.getProject() != null && this.isElementSettingsEnabled()) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " setting " + "use-project-settings" + " (" + true + ") in scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
            }
            preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("use-project-settings", true);
        } else {
            if (_debugPreferences) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "use-project-settings" + " from scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
            }
            preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).remove("use-project-settings");
        }
        try {
            this.fPreferencesService.getRootNode().flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }
}

