/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.IMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.ActionsDataProviderTimeGraphMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.timegraph.BaseDataProviderTimeGraphMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ActionsChartMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ChartMultiViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart.TmfXYChartTimeAdapter;
import org.eclipse.tracecompass.internal.tmf.ui.views.TmfAlignmentSynchronizer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.views.ITimeReset;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.ResetUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractMultiView
extends TmfView
implements ITmfTimeAligned,
ITimeReset {
    private static final TmfAlignmentSynchronizer TIME_ALIGNMENT_SYNCHRONIZER = TmfAlignmentSynchronizer.getInstance();
    private static final double ZOOM_FACTOR = 1.5;
    private static final int DEFAULT_HEIGHT = 22;
    private final @NonNull List<@NonNull IMultiViewer> fLanes = new ArrayList<IMultiViewer>();
    private @NonNull TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private Composite fMainComposite;
    private SashForm fSashForm;
    private Composite fTopRowLeftFiller;
    private Composite fTopRowRightFiller;
    private Composite fBottomRowLeftFiller;
    private Composite fBottomRowRightFiller;
    private ITimeDataProvider fTimeProvider;
    private TimeGraphScale fTopTimeScaleCtrl;
    private TimeGraphScale fBottomTimeScaleCtrl;
    private boolean fTopTimeScaleVisible = true;
    private boolean fBottomTimeScaleVisible = true;
    private Action fZoomInAction;
    private Action fZoomOutAction;
    private ITmfTrace fTrace;

    public AbstractMultiView(String viewId) {
        super(viewId);
    }

    public void createPartControl(Composite parent) {
        Composite mainComposite;
        super.createPartControl(parent);
        this.fMainComposite = mainComposite = new Composite(parent, 0){

            public void redraw() {
                AbstractMultiView.this.redrawTimeScales();
                super.redraw();
            }
        };
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 0;
        mainLayout.horizontalSpacing = 0;
        mainComposite.setLayout((Layout)mainLayout);
        this.fTopRowLeftFiller = new Composite(mainComposite, 0);
        this.fTopRowLeftFiller.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.fTopRowLeftFiller.setLayout((Layout)new FillLayout());
        this.fTopTimeScaleCtrl = new TimeGraphScale(mainComposite, this.fColorScheme);
        this.fTopTimeScaleCtrl.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fTopTimeScaleCtrl.setHeight(22);
        this.fTopRowRightFiller = new Composite(mainComposite, 0);
        this.fTopRowRightFiller.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.fTopRowRightFiller.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(mainComposite, 512);
        sashForm.setBackground(this.fColorScheme.getColor(38));
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fSashForm = sashForm;
        this.fBottomRowLeftFiller = new Composite(mainComposite, 0);
        this.fBottomRowLeftFiller.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.fBottomRowLeftFiller.setLayout((Layout)new FillLayout());
        this.fBottomTimeScaleCtrl = new TimeGraphScale(mainComposite, this.fColorScheme, 1024);
        this.fBottomTimeScaleCtrl.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fBottomTimeScaleCtrl.setHeight(22);
        this.fBottomRowRightFiller = new Composite(mainComposite, 0);
        this.fBottomRowRightFiller.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fBottomRowRightFiller.setLayout((Layout)new FillLayout());
        this.createMenuItems();
        this.createToolbarItems();
        this.selectActiveTrace();
        this.partControlCreated(mainComposite, sashForm);
    }

    protected abstract void partControlCreated(@NonNull Composite var1, @NonNull SashForm var2);

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        for (IMultiViewer lane : this.fLanes) {
            lane.dispose();
        }
        this.fLanes.clear();
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fLanes.isEmpty()) {
            return new TmfTimeViewAlignmentInfo(this.fSashForm.getShell(), this.fSashForm.toDisplay(0, 0), 0);
        }
        return this.fLanes.get(0).getTimeViewAlignmentInfo();
    }

    public int getAvailableWidth(int requestedOffset) {
        if (this.fLanes.isEmpty()) {
            return this.fSashForm.getDisplay().getBounds().width;
        }
        int ret = Integer.MAX_VALUE;
        for (IMultiViewer lane : this.fLanes) {
            ret = Math.min(ret, lane.getAvailableWidth(requestedOffset));
        }
        return ret;
    }

    public void performAlign(int offset, int width) {
        for (IMultiViewer lane : this.fLanes) {
            lane.performAlign(offset, width);
        }
        GridData gdTop = (GridData)this.fTopRowLeftFiller.getLayoutData();
        gdTop.widthHint = offset;
        GridData gdBottom = (GridData)this.fBottomRowLeftFiller.getLayoutData();
        gdBottom.widthHint = offset;
        this.fMainComposite.layout();
    }

    public void resetStartFinishTime(boolean notify) {
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, TmfTimeRange.ETERNITY, this.getTrace());
        this.broadcast((TmfSignal)signal);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.fTrace = signal.getTrace();
        this.redrawTimeScales();
        this.alignViewers(false);
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        this.redrawTimeScales();
        this.alignViewers(false);
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public TimeGraphColorScheme getColorScheme() {
        return this.fColorScheme;
    }

    public void setTopTimeScaleVisible(boolean visible) {
        this.fTopTimeScaleVisible = visible;
        this.showTimeScales();
    }

    public void setBottomTimeScaleVisible(boolean visible) {
        this.fBottomTimeScaleVisible = visible;
        this.showTimeScales();
    }

    protected void hideTimeScales() {
        AbstractMultiView.setControlVisible((Control)this.fTopRowLeftFiller, false);
        AbstractMultiView.setControlVisible((Control)this.fTopTimeScaleCtrl, false);
        AbstractMultiView.setControlVisible((Control)this.fTopRowRightFiller, false);
        AbstractMultiView.setControlVisible((Control)this.fBottomRowLeftFiller, false);
        AbstractMultiView.setControlVisible((Control)this.fBottomTimeScaleCtrl, false);
        AbstractMultiView.setControlVisible((Control)this.fBottomRowRightFiller, false);
        this.fMainComposite.requestLayout();
    }

    protected void showTimeScales() {
        AbstractMultiView.setControlVisible((Control)this.fTopRowLeftFiller, this.fTopTimeScaleVisible);
        AbstractMultiView.setControlVisible((Control)this.fTopTimeScaleCtrl, this.fTopTimeScaleVisible);
        AbstractMultiView.setControlVisible((Control)this.fTopRowRightFiller, this.fTopTimeScaleVisible);
        AbstractMultiView.setControlVisible((Control)this.fBottomRowLeftFiller, this.fBottomTimeScaleVisible);
        AbstractMultiView.setControlVisible((Control)this.fBottomTimeScaleCtrl, this.fBottomTimeScaleVisible);
        AbstractMultiView.setControlVisible((Control)this.fBottomRowRightFiller, this.fBottomTimeScaleVisible);
        this.fMainComposite.requestLayout();
    }

    protected void addLane(@NonNull IMultiViewer lane) {
        if (this.fLanes.isEmpty()) {
            this.showTimeScales();
        }
        this.fLanes.add(lane);
    }

    protected void removeLane(@NonNull IMultiViewer lane) {
        Composite parent;
        if (this.fLanes.isEmpty()) {
            return;
        }
        if (lane instanceof TmfViewer && (parent = ((TmfViewer)lane).getParent()) != this.fSashForm) {
            parent.dispose();
        }
        lane.dispose();
        this.fLanes.remove(lane);
        if (this.fLanes.isEmpty()) {
            this.hideTimeScales();
        }
    }

    protected final List<@NonNull IMultiViewer> getLanes() {
        return ImmutableList.copyOf(this.fLanes);
    }

    protected boolean hasLanes() {
        return !this.fLanes.isEmpty();
    }

    private void selectActiveTrace() {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activeTrace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, activeTrace));
        }
    }

    private void redrawTimeScales() {
        this.fTopTimeScaleCtrl.redraw();
        this.fBottomTimeScaleCtrl.redraw();
    }

    protected void alignViewers(boolean synchronous) {
        this.getSite().getShell().getDisplay().asyncExec(() -> TIME_ALIGNMENT_SYNCHRONIZER.timeViewAlignmentUpdated(new TmfTimeViewAlignmentSignal((Object)this, this.getTimeViewAlignmentInfo(), synchronous)));
    }

    private void setTimeProvider(ITimeDataProvider timeProvider) {
        this.fTimeProvider = timeProvider;
        this.fTopTimeScaleCtrl.setTimeProvider(this.fTimeProvider);
        this.fBottomTimeScaleCtrl.setTimeProvider(this.fTimeProvider);
    }

    protected ITimeDataProvider getTimeProvider() {
        return this.fTimeProvider;
    }

    protected void refreshLayout() {
        this.fSashForm.requestLayout();
    }

    private void zoomIn() {
        long min;
        long time0;
        long time1;
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        long prevRange = prevTime1 - prevTime0;
        if (prevRange == 0L) {
            return;
        }
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if ((time1 = selTime + (long)((double)(prevTime1 - selTime) / 1.5)) - (time0 = selTime - (long)((double)(selTime - prevTime0) / 1.5)) < (min = this.fTimeProvider.getMinTimeInterval())) {
            time0 = selTime - (selTime - prevTime0) * min / prevRange;
            time1 = time0 + min;
        }
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    private void zoomOut() {
        long time0;
        long newInterval;
        long prevTime0 = this.fTimeProvider.getTime0();
        long prevTime1 = this.fTimeProvider.getTime1();
        ITimeDataProvider provider = this.fTimeProvider;
        long selTime = (provider.getSelectionEnd() + provider.getSelectionBegin()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if (prevTime1 - prevTime0 <= 1L) {
            newInterval = 2L;
            time0 = selTime - 1L;
        } else {
            newInterval = (long)Math.ceil((double)(prevTime1 - prevTime0) * 1.5);
            time0 = selTime - (long)Math.ceil((double)(selTime - prevTime0) * 1.5);
        }
        time0 = Math.max(this.fTimeProvider.getMinTime(), Math.min(time0, this.fTimeProvider.getMaxTime() - newInterval));
        long time1 = time0 + newInterval;
        this.fTimeProvider.setStartFinishTimeNotify(time0, time1);
    }

    protected void createToolbarItems() {
        IToolBarManager bars = this.getViewSite().getActionBars().getToolBarManager();
        bars.appendToGroup("additions", (IAction)ResetUtil.createResetAction((ITimeReset)this));
        bars.appendToGroup("additions", (IAction)this.getZoomInAction());
        bars.appendToGroup("additions", (IAction)this.getZoomOutAction());
    }

    protected void createMenuItems() {
    }

    private Action getZoomInAction() {
        if (this.fZoomInAction == null) {
            this.fZoomInAction = new Action(){

                public void run() {
                    AbstractMultiView.this.zoomIn();
                }
            };
            this.fZoomInAction.setText(Messages.TmfTimeGraphViewer_ZoomInActionNameText);
            this.fZoomInAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomInActionToolTipText);
            this.fZoomInAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomin_nav.gif"));
        }
        return this.fZoomInAction;
    }

    private Action getZoomOutAction() {
        if (this.fZoomOutAction == null) {
            this.fZoomOutAction = new Action(){

                public void run() {
                    AbstractMultiView.this.zoomOut();
                }
            };
            this.fZoomOutAction.setText(Messages.TmfTimeGraphViewer_ZoomOutActionNameText);
            this.fZoomOutAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomOutActionToolTipText);
            this.fZoomOutAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomout_nav.gif"));
        }
        return this.fZoomOutAction;
    }

    protected ChartMultiViewer addChartViewer(String providerId, boolean withActions) {
        SashForm sashForm = this.fSashForm;
        ITmfTrace trace = this.getTrace();
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setBackground(this.fColorScheme.getColor(32));
        ChartMultiViewer viewer = withActions ? new ActionsChartMultiViewer(composite, providerId, this.getViewSite()) : new ChartMultiViewer(composite, providerId);
        viewer.setStatusLineManager(this.getViewSite().getActionBars().getStatusLineManager());
        if (!this.hasLanes()) {
            viewer.getChartViewer().getSwtChart().addPaintListener(e -> this.redrawTimeScales());
            TmfXYChartTimeAdapter timeProvider = new TmfXYChartTimeAdapter(Objects.requireNonNull(viewer.getChartViewer()));
            timeProvider.setTimeFormat(Utils.TimeFormat.CALENDAR.convert());
            this.setTimeProvider((ITimeDataProvider)timeProvider);
        }
        this.addLane(viewer);
        if (trace != null) {
            viewer.loadTrace(trace);
        }
        if (viewer.getLeftChildViewer() instanceof AbstractSelectTreeViewer2) {
            AbstractSelectTreeViewer2 tree = (AbstractSelectTreeViewer2)viewer.getLeftChildViewer();
            tree.addSelectionChangeListener(e -> this.alignViewers(false));
        }
        return viewer;
    }

    protected BaseDataProviderTimeGraphMultiViewer addTimeGraphViewer(String providerId, boolean withActions) {
        SashForm sashForm = this.fSashForm;
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setBackground(this.fColorScheme.getColor(32));
        BaseDataProviderTimeGraphMultiViewer viewer = withActions ? new ActionsDataProviderTimeGraphMultiViewer(composite, (ITimeGraphPresentationProvider)new BaseDataProviderTimeGraphPresentationProvider(), (IWorkbenchPartSite)this.getViewSite(), providerId) : new BaseDataProviderTimeGraphMultiViewer(composite, (ITimeGraphPresentationProvider)new BaseDataProviderTimeGraphPresentationProvider(), (IWorkbenchPartSite)this.getViewSite(), providerId);
        viewer.init();
        if (!this.hasLanes()) {
            TimeGraphViewer timeGraphViewer = viewer.getTimeGraphViewer();
            timeGraphViewer.getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    AbstractMultiView.this.redrawTimeScales();
                }
            });
            this.setTimeProvider((ITimeDataProvider)timeGraphViewer);
        }
        this.addLane(viewer);
        return viewer;
    }

    private static void setControlVisible(Control control, boolean visible) {
        GridData gridData = (GridData)control.getLayoutData();
        gridData.exclude = !visible;
        control.setVisible(visible);
    }
}

