/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.PlatformUI;

public final class ModulesTools {
    private static StyledString.Styler OPTIONAL_PARAMETER_STYLE = new StyledString.Styler(){
        private final Font italic = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = this.italic;
            textStyle.foreground = JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
    };

    @Deprecated
    private ModulesTools() {
    }

    public static StyledString getSignature(Method method, boolean useStyledReturnValue) {
        StyledString signature = new StyledString();
        signature.append(method.getName());
        signature.append('(');
        List parameters = ModuleHelper.getParameters((Method)method);
        for (ICodeFactory.Parameter parameter : parameters) {
            if (parameter.isOptional()) {
                signature.append(parameter.getClazz().getSimpleName(), OPTIONAL_PARAMETER_STYLE);
                signature.append(" " + parameter.getName(), OPTIONAL_PARAMETER_STYLE);
            } else {
                signature.append(parameter.getClazz().getSimpleName());
                signature.append(" " + parameter.getName());
            }
            if (parameter.equals(parameters.get(parameters.size() - 1))) continue;
            signature.append(", ");
        }
        signature.append(')');
        signature.append(" : " + method.getReturnType().getSimpleName(), (StyledString.Styler)(useStyledReturnValue ? StyledString.DECORATIONS_STYLER : null));
        return signature;
    }

    @Deprecated
    public static ModuleDefinition getDeclaringModule(Method method) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ArrayList modules = new ArrayList(scriptService.getAvailableModules());
        for (ModuleDefinition module : modules) {
            if (!module.getModuleClass().equals(method.getDeclaringClass())) continue;
            return module;
        }
        for (ModuleDefinition module : modules) {
            if (!method.getDeclaringClass().isAssignableFrom(module.getModuleClass())) continue;
            return module;
        }
        return null;
    }

    public static ModuleDefinition getDeclaringModule(Field field) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ArrayList modules = new ArrayList(scriptService.getAvailableModules());
        for (ModuleDefinition module : modules) {
            if (!module.getModuleClass().equals(field.getDeclaringClass())) continue;
            return module;
        }
        for (ModuleDefinition module : modules) {
            if (!field.getDeclaringClass().isAssignableFrom(module.getModuleClass())) continue;
            return module;
        }
        return null;
    }

    public static int getOptionalParameterCount(Method method) {
        int optional = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] list;
            Annotation[] annotationArray2 = list = annotationArray[n2];
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray2[n4];
                if (annotation.annotationType().equals(ScriptParameter.class) && ScriptParameter.Helper.isOptional((ScriptParameter)((ScriptParameter)annotation))) {
                    ++optional;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return optional;
    }

    public static class ModuleEntry<T> {
        private final ModuleDefinition fModuleDefinition;
        private final T fEntry;

        public ModuleEntry(ModuleDefinition module, T entry) {
            this.fModuleDefinition = module;
            this.fEntry = entry;
        }

        public ModuleDefinition getModuleDefinition() {
            return this.fModuleDefinition;
        }

        public T getEntry() {
            return this.fEntry;
        }

        public int hashCode() {
            return this.fModuleDefinition.hashCode() ^ this.fEntry.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ModuleEntry) {
                return this.fModuleDefinition.equals((Object)((ModuleEntry)o).fModuleDefinition) && this.fEntry.equals(((ModuleEntry)o).fEntry);
            }
            return false;
        }
    }
}

