/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.actions.AbstractResourcesHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.RenameResourceWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameResourceHandler
extends AbstractResourcesHandler {
    private static final String LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY = "org.eclipse.ltk.ui.refactoring.commands.renameResource.newName.parameter.key";
    private static final String LTK_CHECK_COMPOSITE_RENAME_PARAMETER_KEY = "org.eclipse.ltk.ui.refactoring.commands.checkCompositeRename.parameter.key";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object checkCompositeRename = HandlerUtil.getVariable((ExecutionEvent)event, (String)LTK_CHECK_COMPOSITE_RENAME_PARAMETER_KEY);
        if (checkCompositeRename instanceof Boolean) {
            return this.checkForCompositeRename(event);
        }
        this.performRename(event);
        return null;
    }

    private Object checkForCompositeRename(ExecutionEvent event) {
        IResource resource;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && (resource = this.getCurrentResource((IStructuredSelection)sel)) != null) {
            String placeHolderFileName = String.valueOf('a') + resource.getName();
            RenameResourceWizard refactoringWizard = new RenameResourceWizard(resource, placeHolderFileName);
            Change change = this.getChange(refactoringWizard);
            return this.isCompositeChange(change);
        }
        return null;
    }

    private void performRename(ExecutionEvent event) {
        IResource resource;
        ISelection sel;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Object newNameValue = HandlerUtil.getVariable((ExecutionEvent)event, (String)LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY);
        String newName = null;
        if (newNameValue instanceof String) {
            newName = (String)newNameValue;
        }
        if ((sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && (resource = this.getCurrentResource((IStructuredSelection)sel)) != null) {
            RenameResourceWizard refactoringWizard;
            Change change = null;
            RefactoringProcessor processor = null;
            if (newName != null) {
                refactoringWizard = new RenameResourceWizard(resource, newName);
                processor = ((ProcessorBasedRefactoring)refactoringWizard.getRefactoring()).getProcessor();
                change = this.getChange(refactoringWizard);
                refactoringWizard = new RenameResourceWizard(resource, newName);
            } else {
                refactoringWizard = new RenameResourceWizard(resource);
            }
            try {
                if (newName == null || change == null || this.isCompositeChange(change) || !(processor instanceof RenameResourceProcessor)) {
                    RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(refactoringWizard);
                    op.run(activeShell, RefactoringUIMessages.RenameResourceHandler_title);
                } else {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                RefactoringUIPlugin.log(e);
            }
        }
    }

    private Change getChange(RenameResourceWizard refactoringWizard) {
        refactoringWizard.setChangeCreationCancelable(true);
        refactoringWizard.setInitialComputationContext((fork, cancelable, runnable) -> runnable.run((IProgressMonitor)new NullProgressMonitor()));
        return refactoringWizard.internalCreateChange(InternalAPI.INSTANCE, new CreateChangeOperation(new CheckConditionsOperation(refactoringWizard.getRefactoring(), 4), 4), true);
    }

    private boolean isCompositeChange(Change change) {
        return change instanceof CompositeChange && ((CompositeChange)change).getChildren().length > 1;
    }

    private IResource getCurrentResource(IStructuredSelection sel) {
        IResource[] resources = this.getSelectedResources(sel);
        if (resources.length == 1) {
            return resources[0];
        }
        return null;
    }
}

