/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;

public class DataProviderDescriptor
implements IDataProviderDescriptor {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final IDataProviderDescriptor.ProviderType fType;

    private DataProviderDescriptor(Builder builder) {
        this.fId = builder.fId;
        this.fName = builder.fName;
        this.fDescription = builder.fDescription;
        this.fType = Objects.requireNonNull(builder.fType);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public IDataProviderDescriptor.ProviderType getType() {
        return this.fType;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    /* synthetic */ DataProviderDescriptor(Builder builder, DataProviderDescriptor dataProviderDescriptor) {
        this(builder);
    }

    public static class Builder {
        private String fId = "";
        private String fName = "";
        private String fDescription = "";
        private @Nullable IDataProviderDescriptor.ProviderType fType = null;

        public Builder setId(String id) {
            this.fId = id;
            return this;
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setProviderType(IDataProviderDescriptor.ProviderType type) {
            this.fType = type;
            return this;
        }

        public IDataProviderDescriptor build() {
            if (this.fType == null) {
                throw new IllegalStateException("Data provider type not set");
            }
            if (this.fId.isEmpty()) {
                throw new IllegalStateException("Empty data provider ID");
            }
            return new DataProviderDescriptor(this, null);
        }
    }
}

