/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public final class ControlFlowCheckActiveProvider
implements ITimeGraphEntryActiveProvider {
    String fLabel;
    String fTooltip;
    private TmfTimeRange fRange = null;
    private ThreadStatusDataProvider fProvider = null;
    private @NonNull Set<Long> fActive = Collections.emptySet();

    public ControlFlowCheckActiveProvider(String label, String tooltip) {
        this.fLabel = label;
        this.fTooltip = tooltip;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getTooltip() {
        return this.fTooltip;
    }

    public boolean isActive(ITimeGraphEntry element) {
        if (element instanceof ControlFlowEntry) {
            ControlFlowEntry cfe = (ControlFlowEntry)element;
            TmfTraceManager traceManager = TmfTraceManager.getInstance();
            TmfTraceContext traceContext = traceManager.getCurrentTraceContext();
            TmfTimeRange range = traceContext.getSelectionRange();
            if (Objects.equals(range.getStartTime(), range.getEndTime())) {
                range = traceContext.getWindowRange();
            }
            Set<Long> ids = this.getActiveIds(cfe, range);
            return ids.contains(cfe.getEntryModel().getId());
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Set<Long> getActiveIds(ControlFlowEntry cfe, TmfTimeRange range) {
        ITimeGraphDataProvider dataProvider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)cfe);
        if (range.equals((Object)this.fRange) && dataProvider.equals(this.fProvider) || !(dataProvider instanceof ThreadStatusDataProvider)) {
            return this.fActive;
        }
        TimeQueryFilter filter = new TimeQueryFilter(range.getStartTime().toNanos(), range.getEndTime().toNanos(), 2);
        @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        parameters.put("active_thread_filter", true);
        @NonNull TmfModelResponse response = ((ThreadStatusDataProvider)dataProvider).fetchTree(parameters, null);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        if (model == null) {
            return Collections.emptySet();
        }
        this.fRange = range;
        this.fActive = model.getEntries().stream().map(TmfTreeDataModel::getId).collect(Collectors.toSet());
        return this.fActive;
    }
}

