/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import com.google.common.collect.PeekingIterator;
import java.util.PriorityQueue;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatEvent;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.UfEventType;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class UfContext
extends TmfContext {
    private PriorityQueue<PeekingIterator<DatEvent>> fQueue = new PriorityQueue((o1, o2) -> Long.compare(((DatEvent)o1.peek()).getTime(), ((DatEvent)o2.peek()).getTime()));
    private ITmfTrace fTrace;

    public UfContext(Iterable<DatParser> dats, ITmfTrace trace) {
        this.fTrace = trace;
        for (DatParser dp : dats) {
            PeekingIterator<DatEvent> iterator = dp.iterator();
            if (!iterator.hasNext()) continue;
            this.fQueue.add(iterator);
        }
    }

    public @Nullable TmfLongLocation getLocation() {
        return (TmfLongLocation)super.getLocation();
    }

    public ITmfEvent getNext() {
        PeekingIterator<DatEvent> eventSource = this.fQueue.poll();
        if (eventSource != null) {
            DatEvent event = (DatEvent)eventSource.next();
            if (eventSource.hasNext()) {
                this.fQueue.add(eventSource);
            }
            TmfEvent tmfEvent = new TmfEvent(this.fTrace, this.getRank(), this.fTrace.createTimestamp(event.getTime()), UfEventType.lookup(event.getType()), (ITmfEventField)new TmfEventField(":root:", (Object)event, null));
            TmfLongLocation location = this.getLocation();
            if (location != null) {
                this.setLocation((ITmfLocation)new TmfLongLocation(location.getLocationInfo() + 16L));
            } else {
                this.setLocation((ITmfLocation)new TmfLongLocation(16L));
            }
            return tmfEvent;
        }
        return null;
    }
}

