/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;

public class LexicalScope
implements ILexicalScope {
    private int hash = 0;
    private final @NonNull String fName;
    private final @NonNull String fPath;
    private final Map<String, ILexicalScope> fChildren = new ConcurrentHashMap<String, ILexicalScope>();

    protected LexicalScope() {
        this.fPath = "";
        this.fName = "";
    }

    public LexicalScope(ILexicalScope parent, @NonNull String name) {
        this.fName = name;
        this.fPath = parent.getPath().isEmpty() ? this.fName : String.valueOf(parent.getPath()) + '.' + this.fName;
        parent.addChild(name, this);
    }

    @Override
    public void addChild(String name, ILexicalScope child) {
        this.fChildren.put(name, child);
    }

    @Override
    public @NonNull String getName() {
        return this.fName;
    }

    @Override
    public @Nullable ILexicalScope getChild(String name) {
        return this.fChildren.get(name);
    }

    @Override
    public @NonNull String getPath() {
        return this.fPath;
    }

    public String toString() {
        return this.getPath();
    }

    public synchronized int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            this.hash = 31 * (31 + this.fName.hashCode()) + this.fPath.hashCode();
        }
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LexicalScope other = (LexicalScope)obj;
        if (!this.fName.equals(other.fName)) {
            return false;
        }
        return this.fPath.equals(other.fPath);
    }
}

