/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.text.Format;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.AllGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraphGroupBy;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedThreadStatus;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class FlameGraphDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<FlameChartEntryModel> {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider";
    public static final String GROUP_BY_KEY = "group_by";
    public static final String SELECTION_RANGE_KEY = "selection_range";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private static final Comparator<AggregatedCallSite> CCT_COMPARATOR = Comparator.comparingLong(WeightedTree::getWeight).thenComparing(s -> String.valueOf(s.getObject()));
    private final Comparator<WeightedTree<ICallStackSymbol>> CCT_COMPARATOR2 = Comparator.comparing(WeightedTree::getWeight).thenComparing(s -> String.valueOf(s.getObject()));
    private static final Logger LOGGER = TraceCompassLog.getLogger(FlameGraphDataProvider.class);
    private static final Format FORMATTER = SubSecondTimeWithUnitFormat.getInstance();
    private static final String FUNCTION_LEVEL = "Function";
    private static final String EXTRA_LEVEL = "Extra";
    private final ICallGraphProvider fCgProvider;
    private final String fAnalysisId;
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private @Nullable Pair<Map<String, Object>, TmfModelResponse<TmfTreeModel<FlameChartEntryModel>>> fCached;
    private final Map<Long, FlameChartEntryModel> fEntries = new HashMap<Long, FlameChartEntryModel>();
    private final Map<Long, CallGraphEntry> fCgEntries = new HashMap<Long, CallGraphEntry>();
    private final Collection<ISymbolProvider> fSymbolProviders;
    private final Map<Long, Long> fEndTimes = new HashMap<Long, Long>();

    public FlameGraphDataProvider(ITmfTrace trace, ICallGraphProvider module, String secondaryId) {
        super(trace);
        this.fCgProvider = module;
        this.fAnalysisId = secondaryId;
        Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
        symbolProviders.forEach(provider -> provider.loadConfiguration((IProgressMonitor)new NullProgressMonitor()));
        this.fSymbolProviders = symbolProviders;
    }

    public String getId() {
        return "org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider:" + this.fAnalysisId;
    }

    /*
     * Exception decompiling
     */
    public @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull FlameChartEntryModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @Nullable CallGraph getCallGraph(Map<String, Object> fetchParameters, SubMonitor subMonitor) {
        CallGraph callGraph;
        ICallGraphProvider fcProvider = this.fCgProvider;
        if (fcProvider instanceof IAnalysisModule) {
            ((IAnalysisModule)fcProvider).waitForCompletion((IProgressMonitor)subMonitor);
        }
        if (subMonitor.isCanceled()) {
            return null;
        }
        List selectionRange = DataProviderParameterUtils.extractLongList(fetchParameters, (String)SELECTION_RANGE_KEY);
        if (selectionRange == null || selectionRange.size() != 2) {
            callGraph = fcProvider.getCallGraph();
        } else {
            long time0 = (Long)selectionRange.get(0);
            long time1 = (Long)selectionRange.get(1);
            callGraph = fcProvider.getCallGraph(TmfTimestamp.fromNanos((long)Math.min(time0, time1)), TmfTimestamp.fromNanos((long)Math.max(time0, time1)));
        }
        ICallStackGroupDescriptor groupDescriptor = FlameGraphDataProvider.extractGroupDescriptor(fetchParameters, fcProvider);
        if (groupDescriptor != null) {
            callGraph = CallGraphGroupBy.groupCallGraphBy(groupDescriptor, callGraph);
        }
        return callGraph;
    }

    private static @Nullable ICallStackGroupDescriptor extractGroupDescriptor(Map<String, Object> fetchParameters, ICallGraphProvider fcProvider) {
        Object groupBy = fetchParameters.get(GROUP_BY_KEY);
        if (groupBy == null) {
            return null;
        }
        String groupName = String.valueOf(groupBy);
        if (groupName.equals(AllGroupDescriptor.getInstance().getName())) {
            return AllGroupDescriptor.getInstance();
        }
        for (ICallStackGroupDescriptor groupDescriptor : fcProvider.getGroupDescriptors()) {
            if (!groupDescriptor.getName().equals(groupName)) continue;
            return groupDescriptor;
        }
        return null;
    }

    private void buildCallGraphEntries(CallGraph callgraph, List<FlameChartEntryModel.Builder> builder, FlameChartEntryModel.Builder traceEntry) {
        Collection<ICallStackElement> elements = callgraph.getElements();
        for (ICallStackElement element : elements) {
            this.buildChildrenEntries(element, callgraph, builder, traceEntry);
        }
    }

    private ITmfStateSystem elementToStateSystem(CallGraph callgraph, ICallStackElement element) {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"org.eclipse.tracecompass.incubator.callgraph.ss", (long)0L);
        ITmfStateSystemBuilder ssb = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        ArrayList<AggregatedCallSite> rootFunctions = new ArrayList<AggregatedCallSite>(callgraph.getCallingContextTree(element));
        rootFunctions.sort(CCT_COMPARATOR);
        int quarkFct = ssb.getQuarkAbsoluteAndAdd(new String[]{FUNCTION_LEVEL});
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        for (AggregatedCallSite rootFunction : rootFunctions) {
            this.recursivelyAddChildren(ssb, quarkFct, (WeightedTree<ICallStackSymbol>)rootFunction, timestampStack);
        }
        Long endTime = (Long)timestampStack.pop();
        ssb.closeHistory(endTime.longValue());
        return ssb;
    }

    private void recursivelyAddChildren(ITmfStateSystemBuilder ssb, int quarkFct, WeightedTree<ICallStackSymbol> callSite, Deque<Long> timestampStack) {
        Iterator iterator;
        Long lastEnd = timestampStack.peek();
        if (lastEnd == null) {
            return;
        }
        ssb.pushAttribute(lastEnd.longValue(), (Object)new CallSiteCustomValue(callSite), quarkFct);
        timestampStack.push(lastEnd);
        ArrayList<WeightedTree<ICallStackSymbol>> children = new ArrayList<WeightedTree<ICallStackSymbol>>(callSite.getChildren());
        children.sort(this.CCT_COMPARATOR2);
        for (WeightedTree weightedTree : children) {
            this.recursivelyAddChildren(ssb, quarkFct, (WeightedTree<ICallStackSymbol>)weightedTree, timestampStack);
        }
        timestampStack.pop();
        if (callSite instanceof AggregatedCallSite && (iterator = ((AggregatedCallSite)callSite).getExtraChildrenSites().iterator()).hasNext()) {
            int quarkExtra = ssb.getQuarkAbsoluteAndAdd(new String[]{EXTRA_LEVEL});
            long extraStartTime = lastEnd;
            while (iterator.hasNext()) {
                AggregatedCallSite next = (AggregatedCallSite)iterator.next();
                ssb.modifyAttribute(extraStartTime, (Object)new CallSiteCustomValue((WeightedTree<ICallStackSymbol>)next), quarkExtra);
                extraStartTime += next.getWeight();
            }
        }
        long l = timestampStack.pop() + callSite.getWeight();
        timestampStack.push(l);
        ssb.popAttribute(l, quarkFct);
    }

    private void buildChildrenEntries(ICallStackElement element, CallGraph callgraph, List<FlameChartEntryModel.Builder> builder, FlameChartEntryModel.Builder parent) {
        FlameChartEntryModel.Builder entry = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), parent.getId(), element.getName(), 0L, FlameChartEntryModel.EntryType.LEVEL, -1);
        builder.add(entry);
        for (ICallStackElement child : element.getChildrenElements()) {
            this.buildChildrenEntries(child, callgraph, builder, entry);
        }
        long endTime = entry.getEndTime();
        for (FlameChartEntryModel.Builder childEntry : builder) {
            if (childEntry.getParentId() != entry.getId()) continue;
            endTime = Math.max(childEntry.getEndTime(), endTime);
        }
        entry.setEndTime(endTime);
        if (!element.isLeaf()) {
            return;
        }
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        ITmfStateSystem ss = this.elementToStateSystem(callgraph, element);
        entry.setEndTime(ss.getCurrentEndTime());
        int quark = ss.optQuarkAbsolute(new String[]{FUNCTION_LEVEL});
        if (quark == -2) {
            return;
        }
        int i = 0;
        for (Integer subQuark : ss.getSubAttributes(quark, false)) {
            FlameChartEntryModel.Builder child = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), entry.getId(), String.valueOf(i), 0L, FlameChartEntryModel.EntryType.FUNCTION, i);
            child.setEndTime(ss.getCurrentEndTime());
            builder.add(child);
            ++i;
            this.fCgEntries.put(child.getId(), new CallGraphEntry(element, ss, subQuark));
        }
        quark = ss.optQuarkAbsolute(new String[]{EXTRA_LEVEL});
        if (quark == -2) {
            return;
        }
        FlameChartEntryModel.Builder child = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), entry.getId(), Objects.requireNonNull(Messages.FlameGraph_KernelStatusTitle), 0L, FlameChartEntryModel.EntryType.KERNEL, -1);
        child.setEndTime(ss.getCurrentEndTime());
        builder.add(child);
        this.fCgEntries.put(child.getId(), new CallGraphEntry(element, ss, quark));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SubMonitor subMonitor = Objects.requireNonNull(SubMonitor.convert((IProgressMonitor)monitor, (String)"FlameGraphDataProvider#fetchRowModel", (int)2));
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        ArrayList<ITimeGraphRowModel> rowModels = new ArrayList<ITimeGraphRowModel>();
        Collection<Object> selected = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selected == null) {
            selected = this.fEntries.keySet();
        }
        ArrayList<CallGraphEntry> selectedEntries = new ArrayList<CallGraphEntry>();
        HashMultimap requested = HashMultimap.create();
        for (Long l : selected) {
            CallGraphEntry entry = this.fCgEntries.get(l);
            if (entry == null) continue;
            selectedEntries.add(entry);
            requested.put((Object)new Pair((Object)entry.fSs, (Object)entry.fElement), (Object)new Pair((Object)entry.fQuark, (Object)l));
        }
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> hashMap = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            hashMap.putAll(this.computeRegexPredicate(regexesMap));
        }
        if (subMonitor.isCanceled()) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        try {
            for (Pair element : requested.keySet()) {
                if (subMonitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                Collection depths = requested.get((Object)element);
                rowModels.addAll(this.getStatesForElement(times, hashMap, (IProgressMonitor)subMonitor, (ITmfStateSystem)element.getFirst(), depths));
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return new TmfModelResponse((Object)new TimeGraphModel(rowModels), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private List<ITimeGraphRowModel> getStatesForElement(List<Long> times, Map<Integer, Predicate<Multimap<String, Object>>> predicates, IProgressMonitor monitor, ITmfStateSystem ss, Collection<Pair<Integer, Long>> depths) throws StateSystemDisposedException {
        ArrayList<Integer> quarks = new ArrayList<Integer>();
        for (Pair<Integer, Long> pair : depths) {
            quarks.add((Integer)pair.getFirst());
        }
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        long ssEndTime = ss.getCurrentEndTime();
        for (ITmfStateInterval interval : ss.query2D(quarks, times)) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (interval.getStartTime() == ssEndTime && interval.getStartTime() == interval.getEndTime() && interval.getValue() == null) continue;
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ArrayList<ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Pair<Integer, Long> pair : depths) {
            int quark = (Integer)pair.getFirst();
            NavigableSet states = intervals.get((Object)quark);
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ArrayList eventList = new ArrayList();
            Long key = Objects.requireNonNull((Long)pair.getSecond());
            states.forEach(i -> {
                ITimeGraphState timegraphState = this.createTimeGraphState((ITmfStateInterval)i, ssEndTime);
                this.applyFilterAndAddState(eventList, timegraphState, key, predicates, monitor);
            });
            rows.add((ITimeGraphRowModel)new TimeGraphRowModel(key.longValue(), eventList));
        }
        return rows;
    }

    private ITimeGraphState createTimeGraphState(ITmfStateInterval interval, long ssEndTime) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + (long)(ssEndTime == interval.getEndTime() ? 0 : 1);
        Object valueObject = interval.getValue();
        if (valueObject instanceof CallSiteCustomValue) {
            WeightedTree callsite = ((CallSiteCustomValue)((Object)valueObject)).fCallSite;
            ICallStackSymbol value = (ICallStackSymbol)callsite.getObject();
            String resolved = value.resolve(this.fSymbolProviders);
            if (callsite instanceof AggregatedThreadStatus) {
                return new TimeGraphState(startTime, duration, ((AggregatedThreadStatus)callsite).getProcessStatus().getStateValue().unboxInt(), resolved);
            }
            return new TimeGraphState(startTime, duration, value.hashCode(), resolved);
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null || times.size() != 1) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.FAILED, "Invalid time requested for tooltip");
        }
        List items = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (items == null || items.size() != 1) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.FAILED, "Invalid selection requested for tooltip");
        }
        Long time = (Long)times.get(0);
        Long item = (Long)items.get(0);
        CallGraphEntry callGraphEntry = this.fCgEntries.get(item);
        if (callGraphEntry == null) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        WeightedTree<ICallStackSymbol> callSite = FlameGraphDataProvider.findCallSite(callGraphEntry, time);
        if (callSite != null) {
            return new TmfModelResponse(this.getTooltip(callSite), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private Map<String, String> getTooltip(WeightedTree<ICallStackSymbol> tree) {
        if (!(tree instanceof AggregatedCallSite)) {
            return Collections.emptyMap();
        }
        AggregatedCallSite callSite = (AggregatedCallSite)tree;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Messages.FlameGraph_Symbol, (Object)((ICallStackSymbol)callSite.getObject()).resolve(this.fSymbolProviders));
        for (Map.Entry entry : callSite.getStatistics().entrySet()) {
            String statType = String.valueOf(entry.getKey());
            IStatistics stats = (IStatistics)entry.getValue();
            if (stats.getMax() == -1L) continue;
            builder.put((Object)statType, (Object)"");
            String lowerType = statType.toLowerCase();
            builder.put((Object)("\t" + Messages.FlameGraph_Total + ' ' + lowerType), (Object)FORMATTER.format(stats.getTotal()));
            builder.put((Object)("\t" + Messages.FlameGraph_Average + ' ' + lowerType), (Object)FORMATTER.format(stats.getMean()));
            builder.put((Object)("\t" + Messages.FlameGraph_Max + ' ' + lowerType), (Object)FORMATTER.format(stats.getMax()));
            builder.put((Object)("\t" + Messages.FlameGraph_Min + ' ' + lowerType), (Object)FORMATTER.format(stats.getMin()));
            builder.put((Object)("\t" + Messages.FlameGraph_Deviation + ' ' + lowerType), (Object)FORMATTER.format(stats.getStdDev()));
        }
        return builder.build();
    }

    private static @Nullable WeightedTree<ICallStackSymbol> findCallSite(CallGraphEntry cgEntry, Long time) {
        try {
            ITmfStateInterval interval = cgEntry.fSs.querySingleState(time.longValue(), cgEntry.fQuark.intValue());
            Object valueObject = interval.getValue();
            if (valueObject instanceof CallSiteCustomValue) {
                return ((CallSiteCustomValue)((Object)valueObject)).fCallSite;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public TmfModelResponse<List<FlameChartEntryModel>> fetchTree(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        TmfModelResponse<@NonNull TmfTreeModel<@NonNull FlameChartEntryModel>> response = this.fetchTree(parameters, monitor);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        List treeModel = null;
        if (model != null) {
            treeModel = model.getEntries();
        }
        return new TmfModelResponse((Object)treeModel, response.getStatus(), response.getStatusMessage());
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphRowModel>> fetchRowModel(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        TmfModelResponse<TimeGraphModel> response = this.fetchRowModel(parameters, monitor);
        TimeGraphModel model = (TimeGraphModel)response.getModel();
        List rows = null;
        if (model != null) {
            rows = model.getRows();
        }
        return new TmfModelResponse((Object)rows, response.getStatus(), response.getStatusMessage());
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }

    private /* synthetic */ void lambda$5(FlameChartEntryModel entry) {
        this.fEntries.put(entry.getId(), entry);
        this.fEndTimes.put(entry.getId(), entry.getEndTime());
    }

    private static class CallGraphEntry {
        private final ICallStackElement fElement;
        private ITmfStateSystem fSs;
        private Integer fQuark;

        public CallGraphEntry(ICallStackElement element, ITmfStateSystem ss, Integer quark) {
            this.fElement = element;
            this.fSs = ss;
            this.fQuark = quark;
        }
    }

    private static class CallSiteCustomValue
    extends CustomStateValue {
        private WeightedTree<ICallStackSymbol> fCallSite;

        public CallSiteCustomValue(WeightedTree<ICallStackSymbol> rootFunction) {
            this.fCallSite = rootFunction;
        }

        public int compareTo(ITmfStateValue o) {
            if (!(o instanceof CallSiteCustomValue)) {
                return -1;
            }
            return this.fCallSite.compareTo(((CallSiteCustomValue)o).fCallSite);
        }

        protected Byte getCustomTypeId() {
            return (byte)103;
        }

        protected void serializeValue(ISafeByteBufferWriter buffer) {
            throw new UnsupportedOperationException("This state value is not meant to be written to disk");
        }

        protected int getSerializedValueSize() {
            throw new UnsupportedOperationException("This state value is not meant to be written to disk");
        }
    }
}

