/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysisReport;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfReportElement;

public class TmfReportsElement
extends TmfProjectModelElement {
    public static final String PATH_ELEMENT = ".reports";
    private static final String ELEMENT_NAME = Messages.TmfReportsElement_Name;
    private final BiMap<String, IOnDemandAnalysisReport> fCurrentReports = HashBiMap.create();

    protected TmfReportsElement(IResource resource, TmfCommonProjectElement parent) {
        super(ELEMENT_NAME, resource, parent);
    }

    @Override
    public TmfCommonProjectElement getParent() {
        return (TmfCommonProjectElement)super.getParent();
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.REPORTS_ICON;
    }

    @Override
    protected void refreshChildren() {
    }

    public void addReport(IOnDemandAnalysisReport report) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath nodePath = this.getResource().getFullPath();
        String reportDisplayName = report.getName();
        int i = 1;
        while (this.fCurrentReports.containsKey((Object)reportDisplayName)) {
            reportDisplayName = String.valueOf(report.getName()) + " #" + ++i;
        }
        this.fCurrentReports.put((Object)reportDisplayName, (Object)report);
        IFolder analysisRes = (IFolder)NonNullUtils.checkNotNull((Object)root.getFolder(nodePath.append(reportDisplayName)));
        TmfReportElement elem = new TmfReportElement(reportDisplayName, (IResource)analysisRes, this, report);
        this.addChild(elem);
        this.refresh();
    }

    public void removeReport(IOnDemandAnalysisReport report) {
        String displayName = (String)this.fCurrentReports.inverse().remove((Object)report);
        this.getChildren().stream().filter(elem -> elem.getName().equals(displayName)).findFirst().ifPresent(this::removeChild);
        this.refresh();
    }
}

