/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph;

import com.google.common.collect.ImmutableMap;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.FlameViewPalette;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlameGraphView;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.Messages;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class FlameGraphPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final Format FORMATTER = new SubSecondTimeWithUnitFormat();
    private @Nullable FlameGraphView fView;
    private @Nullable Integer fAverageCharWidth;
    private FlameViewPalette fFlameViewPalette = FlameViewPalette.getInstance();

    public StateItem[] getStateTable() {
        return this.fFlameViewPalette.getStateTable();
    }

    public boolean displayTimesInTooltip() {
        return false;
    }

    public String getStateTypeName() {
        return Objects.requireNonNull(Messages.FlameGraph_Depth);
    }

    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        if (!(event instanceof FlamegraphEvent)) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        String funcSymbol = null;
        FlamegraphEvent fgEvent = (FlamegraphEvent)event;
        Object symbol = fgEvent.getSymbol();
        if (activeTrace != null && symbol instanceof ICallStackSymbol) {
            funcSymbol = ((ICallStackSymbol)symbol).resolve(SymbolProviderManager.getInstance().getSymbolProviders(activeTrace));
        }
        builder.put((Object)Messages.FlameGraph_Symbol, (Object)(funcSymbol == null ? String.valueOf(fgEvent.getSymbol()) : String.valueOf(funcSymbol) + " (" + fgEvent.getSymbol() + ")"));
        long nb = fgEvent.getNumberOfCalls();
        builder.put((Object)Messages.FlameGraph_NbCalls, (Object)NumberFormat.getIntegerInstance().format(nb));
        Map<String, String> tooltip = ((FlamegraphEvent)event).getTooltip(FORMATTER);
        builder.putAll(tooltip);
        return builder.build();
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        int cfIndex;
        if (event instanceof FlamegraphEvent) {
            FlamegraphEvent flameGraphEvent = (FlamegraphEvent)event;
            return FlameViewPalette.getIndexForValue(flameGraphEvent.getValue());
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        if (event instanceof TimeEvent && (cfIndex = this.fFlameViewPalette.getControlFlowIndex(event)) >= 0) {
            return cfIndex;
        }
        return FlameViewPalette.MULTIPLE_STATE_INDEX;
    }

    public void postDrawEvent(@Nullable ITimeEvent event, @Nullable Rectangle bounds, @Nullable GC gc) {
        if (bounds == null || gc == null) {
            return;
        }
        Integer averageCharWidth = this.fAverageCharWidth;
        if (averageCharWidth == null) {
            this.fAverageCharWidth = averageCharWidth = Integer.valueOf(gc.getFontMetrics().getAverageCharWidth());
        }
        if (bounds.width <= averageCharWidth) {
            return;
        }
        if (!(event instanceof FlamegraphEvent)) {
            return;
        }
        String funcSymbol = "";
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activeTrace != null) {
            FlamegraphEvent fgEvent = (FlamegraphEvent)event;
            Object symbol = fgEvent.getSymbol();
            funcSymbol = symbol instanceof ICallStackSymbol ? ((ICallStackSymbol)symbol).resolve(SymbolProviderManager.getInstance().getSymbolProviders(activeTrace)) : String.valueOf(symbol);
        }
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText((GC)gc, (String)funcSymbol, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }

    public @Nullable FlameGraphView getView() {
        return this.fView;
    }

    public void setView(FlameGraphView view) {
        this.fView = view;
    }
}

