/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.ITree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.WeightedTreeView;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class WeightedTreeViewer
extends AbstractTmfTreeViewer {
    private static final Comparator<TreeNodeEntry> COMPARATOR = (o1, o2) -> Long.compare(o2.getTreeNode().getWeight(), o1.getTreeNode().getWeight());
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private MenuManager fTablePopupMenuManager;
    private IWeightedTreeProvider.MetricType fWeightType = new IWeightedTreeProvider.MetricType(String.valueOf(Messages.WeightedTreeViewer_Weight), IWeightedTreeProvider.DataType.NUMBER, null);
    private boolean fInitialized = false;
    private final WeightedTreeView fView;
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{Objects.requireNonNull(Messages.WeightedTreeViewer_Element), Objects.requireNonNull(Messages.WeightedTreeViewer_Weight)};

    public WeightedTreeViewer(@Nullable Composite parent, WeightedTreeView view) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new WeightedTreeLabelProvider(Collections.emptyList()));
        this.fView = view;
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TreeViewer viewer = this.getTreeViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        Tree tree = this.getTreeViewer().getTree();
        tree.setMenu(tablePopup);
        this.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent event) {
                Object selection;
                if (event == null) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof TmfTreeViewerEntry) {
                    HashSet trees = new HashSet();
                    IWeightedTreeProvider treeProvider = null;
                    for (ITmfTreeViewerEntry entry : ((TmfTreeViewerEntry)selection).getChildren()) {
                        if (!(entry instanceof TreeNodeEntry)) continue;
                        trees.add(((TreeNodeEntry)entry).getTreeNode());
                        treeProvider = ((TreeNodeEntry)entry).fTreeProvider;
                    }
                    if (treeProvider != null) {
                        WeightedTreeViewer.this.fView.elementSelected(trees, treeProvider);
                    }
                }
            }
        });
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<TmfTreeColumnData> getColumnData() {
                return Collections.emptyList();
            }
        };
    }

    private static ITmfTreeColumnDataProvider getColumnDataProvider(final IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        final List additionalMetrics = treeProvider.getAdditionalMetrics();
        return new ITmfTreeColumnDataProvider(){

            public List<@Nullable TmfTreeColumnData> getColumnData() {
                ArrayList<@Nullable TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>(2 + additionalMetrics.size());
                TmfTreeColumnData column = new TmfTreeColumnData(DEFAULT_COLUMN_NAMES[0]);
                column.setAlignment(16384);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof TreeNodeEntry) || !(e2 instanceof TreeNodeEntry)) {
                            return 0;
                        }
                        TreeNodeEntry n1 = (TreeNodeEntry)((Object)e1);
                        TreeNodeEntry n2 = (TreeNodeEntry)((Object)e2);
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(treeProvider.getWeightType().getTitle());
                column.setPercentageProvider((TmfTreeColumnData.ITmfColumnPercentageProvider)new WeightedPercentageProvider());
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof TreeNodeEntry) || !(e2 instanceof TreeNodeEntry)) {
                            return 0;
                        }
                        TreeNodeEntry n1 = (TreeNodeEntry)((Object)e1);
                        TreeNodeEntry n2 = (TreeNodeEntry)((Object)e2);
                        WeightedTree<?> callsite1 = n1.getTreeNode();
                        WeightedTree<?> callsite2 = n2.getTreeNode();
                        return Long.compare(callsite1.getWeight(), callsite2.getWeight());
                    }
                });
                columns.add(column);
                int metricIndex = 0;
                for (IWeightedTreeProvider.MetricType metric : additionalMetrics) {
                    column = new TmfTreeColumnData(metric.getTitle());
                    column.setAlignment(131072);
                    final int index = metricIndex;
                    switch (metric.getDataType()) {
                        case NUMBER: 
                        case NANOSECONDS: 
                        case BYTES: 
                        case BINARY_SPEED: {
                            column.setComparator(new ViewerComparator(){

                                public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                                    if (!(e1 instanceof TreeNodeEntry) || !(e2 instanceof TreeNodeEntry)) {
                                        return 0;
                                    }
                                    Object metricValue1 = ((TreeNodeEntry)((Object)e1)).getMetric(index);
                                    Object metricValue2 = ((TreeNodeEntry)((Object)e2)).getMetric(index);
                                    if (metricValue1 instanceof Long && metricValue2 instanceof Long) {
                                        return Long.compare((Long)metricValue1, (Long)metricValue2);
                                    }
                                    if (metricValue1 instanceof Double && metricValue2 instanceof Double) {
                                        return Double.compare((Double)metricValue1, (Double)metricValue2);
                                    }
                                    if (metricValue1 instanceof Number && metricValue2 instanceof Number) {
                                        return Double.compare(((Number)metricValue1).doubleValue(), ((Number)metricValue2).doubleValue());
                                    }
                                    return String.valueOf(metricValue1).compareTo(String.valueOf(metricValue2));
                                }
                            });
                            break;
                        }
                        case OTHER: {
                            column.setComparator(new ViewerComparator(){

                                public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                                    if (!(e1 instanceof TreeNodeEntry) || !(e2 instanceof TreeNodeEntry)) {
                                        return 0;
                                    }
                                    Object metricValue1 = ((TreeNodeEntry)((Object)e1)).getMetric(index);
                                    Object metricValue2 = ((TreeNodeEntry)((Object)e2)).getMetric(index);
                                    return String.valueOf(metricValue1).compareTo(String.valueOf(metricValue2));
                                }
                            });
                            break;
                        }
                    }
                    columns.add(column);
                    ++metricIndex;
                }
                column = new TmfTreeColumnData("");
                columns.add(column);
                return columns;
            }
        };
    }

    public void initializeDataSource(ITmfTrace trace) {
        Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> modules = this.fView.getWeightedTrees(trace);
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).schedule();
            }
        });
        if (!modules.isEmpty() && !this.fInitialized) {
            this.initializeViewer(modules.iterator().next());
            this.fInitialized = true;
        }
    }

    @TmfSignalHandler
    public void analysisStart(TmfStartAnalysisSignal signal) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> modules = this.fView.getWeightedTrees(trace);
        if (modules.contains(signal.getAnalysisModule())) {
            this.updateContent(trace.getStartTime().toNanos(), trace.getEndTime().toNanos(), false);
        }
    }

    private void initializeViewer(IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        this.fWeightType = treeProvider.getWeightType();
        ITmfTreeColumnDataProvider columns = WeightedTreeViewer.getColumnDataProvider(treeProvider);
        Display.getDefault().asyncExec(() -> {
            this.setTreeColumns(columns.getColumnData());
            this.setLabelProvider((IBaseLabelProvider)new WeightedTreeLabelProvider(treeProvider.getAdditionalMetrics()));
        });
    }

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
    }

    protected @Nullable ITmfTreeViewerEntry updateElements(ITmfTrace trace, long start, long end, boolean isSelection) {
        Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> modules = this.fView.getWeightedTrees(trace);
        if (modules.isEmpty()) {
            return null;
        }
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).waitForCompletion();
            }
        });
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        for (IWeightedTreeProvider<?, ?, WeightedTree<?>> module : modules) {
            if (isSelection) {
                this.setSelection(start, end, entryList, module, true, NULL_MONITOR);
                continue;
            }
            this.setGlobalData(entryList, module);
        }
        return root;
    }

    private <E> void setGlobalData(List<ITmfTreeViewerEntry> entryList, IWeightedTreeProvider<?, E, WeightedTree<?>> module) {
        Collection elements = module.getElements();
        for (Object element : elements) {
            ElementEntry entry = new ElementEntry(element, module);
            entryList.add((ITmfTreeViewerEntry)entry);
        }
    }

    private <E> void setSelection(long start, long end, List<ITmfTreeViewerEntry> entryList, IWeightedTreeProvider<?, E, WeightedTree<?>> module, boolean isSelection, IProgressMonitor monitor) {
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
    }

    protected String getTotalLabel() {
        return Objects.requireNonNull(Messages.WeightedTreeViewer_LabelTotal);
    }

    protected String getSelectionLabel() {
        return Objects.requireNonNull(Messages.WeightedTreeViewer_LabelSelection);
    }

    protected void setSelectionRange(long selectionBeginTime, long selectionEndTime) {
        super.setSelectionRange(selectionBeginTime, selectionEndTime);
        this.updateContent(selectionBeginTime, selectionEndTime, true);
    }

    protected class ElementEntry<@NonNull E>
    extends TmfTreeViewerEntry {
        private final E fThisElement;
        private final IWeightedTreeProvider<?, E, WeightedTree<?>> fTreeProvider;
        private @Nullable List<ITmfTreeViewerEntry> fChildren;

        public ElementEntry(E element, IWeightedTreeProvider<?, E, WeightedTree<?>> provider) {
            super(String.valueOf(element));
            this.fThisElement = element;
            this.fTreeProvider = provider;
        }

        public E getElement() {
            return this.fThisElement;
        }

        public boolean hasChildren() {
            return true;
        }

        public List<ITmfTreeViewerEntry> getChildren() {
            List<ITmfTreeViewerEntry> children = this.fChildren;
            if (children == null) {
                children = new ArrayList<ITmfTreeViewerEntry>();
                E thisNode = this.fThisElement;
                if (thisNode instanceof ITree) {
                    children.addAll(this.getChildrenElements((ITree)thisNode));
                }
                children.addAll(this.getChildrenTreeNodes());
                this.fChildren = children;
            }
            return children;
        }

        public long getTotalLength() {
            List<ITmfTreeViewerEntry> childrenCallSites = this.getChildren();
            long length = 0L;
            for (ITmfTreeViewerEntry callsiteEntry : childrenCallSites) {
                length += ((TreeNodeEntry)callsiteEntry).getTreeNode().getWeight();
            }
            return length;
        }

        private List<ITmfTreeViewerEntry> getChildrenTreeNodes() {
            ArrayList<ITmfTreeViewerEntry> list = new ArrayList<ITmfTreeViewerEntry>();
            for (WeightedTree callsite : this.fTreeProvider.getTreesFor(this.fThisElement)) {
                list.add((ITmfTreeViewerEntry)new TreeNodeEntry(callsite, this, this.fTreeProvider));
            }
            return list;
        }

        private List<ITmfTreeViewerEntry> getChildrenElements(ITree<?> thisNode) {
            ArrayList<ITmfTreeViewerEntry> list = new ArrayList<ITmfTreeViewerEntry>();
            for (ITree elChild : thisNode.getChildren()) {
                list.add((ITmfTreeViewerEntry)new ElementEntry<ITree>(elChild, this.fTreeProvider));
            }
            return list;
        }
    }

    protected class HiddenTreeViewerEntry
    extends TmfTreeViewerEntry {
        public HiddenTreeViewerEntry(String name) {
            super(name);
        }
    }

    protected class TreeNodeEntry
    extends TmfTreeViewerEntry {
        private final WeightedTree<?> fTreeNode;
        private final IWeightedTreeProvider<?, ?, WeightedTree<?>> fTreeProvider;
        private @Nullable List<ITmfTreeViewerEntry> fChildren;

        public TreeNodeEntry(WeightedTree<?> callsite, TmfTreeViewerEntry parent, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
            super(treeProvider.toDisplayString(callsite));
            this.fChildren = null;
            this.fTreeNode = callsite;
            this.setParent((ITmfTreeViewerEntry)parent);
            this.fTreeProvider = treeProvider;
        }

        public WeightedTree<?> getTreeNode() {
            return this.fTreeNode;
        }

        public boolean hasChildren() {
            return !this.fTreeNode.getChildren().isEmpty();
        }

        public Object getMetric(int metricIndex) {
            return this.fTreeProvider.getAdditionalMetric(this.fTreeNode, metricIndex);
        }

        public List<ITmfTreeViewerEntry> getChildren() {
            List<ITmfTreeViewerEntry> children = this.fChildren;
            if (children == null) {
                ArrayList<TreeNodeEntry> cctChildren = new ArrayList<TreeNodeEntry>();
                for (WeightedTree callsite : this.fTreeNode.getChildren()) {
                    TreeNodeEntry entry = new TreeNodeEntry(callsite, this, this.fTreeProvider);
                    int index = Collections.binarySearch(cctChildren, entry, COMPARATOR);
                    cctChildren.add(index < 0 ? -index - 1 : index, entry);
                }
                this.fChildren = children = new ArrayList<ITmfTreeViewerEntry>(cctChildren);
            }
            return children;
        }
    }

    private static class WeightedPercentageProvider
    implements TmfTreeColumnData.ITmfColumnPercentageProvider {
        private WeightedPercentageProvider() {
        }

        public double getPercentage(@Nullable Object data) {
            double value = 0.0;
            if (data instanceof TreeNodeEntry) {
                TreeNodeEntry entry = (TreeNodeEntry)((Object)data);
                WeightedTree<?> callSite = entry.getTreeNode();
                TreeNodeEntry parentEntry = entry;
                while (parentEntry != null && !(parentEntry instanceof ElementEntry)) {
                    parentEntry = parentEntry.getParent();
                }
                if (parentEntry != null) {
                    value = (double)callSite.getWeight() / (double)((ElementEntry)((Object)parentEntry)).getTotalLength();
                }
            }
            return value;
        }
    }

    private class WeightedTreeLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private final Map<Integer, IWeightedTreeProvider.MetricType> fFormatMap;

        public WeightedTreeLabelProvider(List<IWeightedTreeProvider.MetricType> list) {
            int metricIndex = DEFAULT_COLUMN_NAMES.length;
            this.fFormatMap = new HashMap<Integer, IWeightedTreeProvider.MetricType>();
            for (IWeightedTreeProvider.MetricType metric : list) {
                this.fFormatMap.put(metricIndex, metric);
                ++metricIndex;
            }
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            String value = "";
            if (element instanceof HiddenTreeViewerEntry) {
                if (columnIndex == 0) {
                    value = ((HiddenTreeViewerEntry)((Object)element)).getName();
                }
            } else if (element instanceof ElementEntry) {
                ElementEntry entry = (ElementEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                value = "";
            } else if (element instanceof TreeNodeEntry) {
                TreeNodeEntry entry = (TreeNodeEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                WeightedTree<?> callSite = entry.getTreeNode();
                if (columnIndex == 1) {
                    return String.valueOf(WeightedTreeViewer.this.fWeightType.format((Object)callSite.getWeight()));
                }
                IWeightedTreeProvider.MetricType metricType = this.fFormatMap.get(columnIndex);
                if (metricType != null) {
                    return metricType.format(entry.getMetric(columnIndex - DEFAULT_COLUMN_NAMES.length));
                }
            }
            return Objects.requireNonNull(value);
        }
    }
}

