/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.IHeaderCustomizationElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyHeaderHandler
implements ICSSPropertyHandler {
    private static final String SWT_HEADER_COLOR = "swt-header-color";
    private static final String SWT_HEADER_BACKGROUND_COLOR = "swt-header-background-color";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(element instanceof IHeaderCustomizationElement) || !(element instanceof ElementAdapter)) {
            return false;
        }
        IHeaderCustomizationElement headerCustomizationElement = (IHeaderCustomizationElement)element;
        ElementAdapter elementAdapter = (ElementAdapter)element;
        Object nativeWidget = elementAdapter.getNativeWidget();
        if (!(nativeWidget instanceof Widget)) {
            return false;
        }
        Widget widget = (Widget)nativeWidget;
        return this.setHeaderColor(property, value, engine, headerCustomizationElement, widget);
    }

    private boolean setHeaderColor(String property, CSSValue value, CSSEngine engine, IHeaderCustomizationElement headerCustomizationElement, Widget widget) throws Exception {
        if (SWT_HEADER_COLOR.equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
            headerCustomizationElement.setHeaderColor(newColor);
            return true;
        }
        if (SWT_HEADER_BACKGROUND_COLOR.equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
            headerCustomizationElement.setHeaderBackgroundColor(newColor);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

