/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.preferences;

import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.Messages;
import org.eclipse.ease.ui.preferences.ModulesContentProvider;
import org.eclipse.ease.ui.preferences.ModulesLabelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ModulesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCES_ID = "org.eclipse.ease.preferences.modules";
    private TreeViewer fVisibleTreeViewer;
    private TreeViewer fInvisibleTreeViewer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblUseDragAnd = new Label(composite, 0);
        lblUseDragAnd.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblUseDragAnd.setText(Messages.ModulesPage_dragDrop);
        Label lblVisibleModules = new Label(composite, 0);
        lblVisibleModules.setText(Messages.ModulesPage_visibleModules);
        Label lblHiddenModules = new Label(composite, 0);
        lblHiddenModules.setText(Messages.ModulesPage_hiddenModules);
        this.fVisibleTreeViewer = new TreeViewer(composite, 2050);
        Tree tree = this.fVisibleTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fVisibleTreeViewer.setLabelProvider((IBaseLabelProvider)new ModulesLabelProvider());
        this.fVisibleTreeViewer.setContentProvider((IContentProvider)new ModulesContentProvider());
        this.fVisibleTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof IPath ? 1 : 2;
            }
        });
        this.fVisibleTreeViewer.setFilters(new ViewerFilter[]{new VisibilityFilter(true)});
        this.addDNDSupport((StructuredViewer)this.fVisibleTreeViewer, true);
        this.fInvisibleTreeViewer = new TreeViewer(composite, 2050);
        Tree tree_1 = this.fInvisibleTreeViewer.getTree();
        tree_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fInvisibleTreeViewer.setLabelProvider((IBaseLabelProvider)new ModulesLabelProvider());
        this.fInvisibleTreeViewer.setContentProvider((IContentProvider)new ModulesContentProvider());
        this.fInvisibleTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof IPath ? 1 : 2;
            }
        });
        this.fInvisibleTreeViewer.setFilters(new ViewerFilter[]{new VisibilityFilter(false)});
        this.addDNDSupport((StructuredViewer)this.fInvisibleTreeViewer, false);
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Collection modules = scriptService.getAvailableModules();
        this.fVisibleTreeViewer.setInput((Object)modules);
        this.fInvisibleTreeViewer.setInput((Object)modules);
        return composite;
    }

    private void addDNDSupport(final StructuredViewer viewer, final boolean dropVisible) {
        viewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(viewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        });
        viewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof ModuleDefinition) {
                        ((ModuleDefinition)element).setVisible(dropVisible);
                    } else if (element instanceof IPath) {
                        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                        for (ModuleDefinition definition : scriptService.getAvailableModules()) {
                            if (!((IPath)element).isPrefixOf(definition.getPath())) continue;
                            definition.setVisible(dropVisible);
                        }
                    }
                    ++n2;
                }
                ModulesPage.this.fVisibleTreeViewer.refresh();
                ModulesPage.this.fInvisibleTreeViewer.refresh();
            }
        });
    }

    protected void performDefaults() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        for (ModuleDefinition definition : scriptService.getAvailableModules()) {
            definition.resetVisible();
        }
        this.fVisibleTreeViewer.refresh();
        this.fInvisibleTreeViewer.refresh();
    }

    private class VisibilityFilter
    extends ViewerFilter {
        private final boolean fShowVisible;

        public VisibilityFilter(boolean showVisible) {
            this.fShowVisible = showVisible;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ModuleDefinition) {
                return ((ModuleDefinition)element).isVisible() == this.fShowVisible;
            }
            if (element instanceof IPath) {
                IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                for (ModuleDefinition definition : scriptService.getAvailableModules()) {
                    if (!((IPath)element).isPrefixOf(definition.getPath()) || definition.isVisible() != this.fShowVisible) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

