/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.XMLCatalogEntryContentProvider;
import org.eclipse.wst.xml.ui.internal.dialogs.XMLCatalogEntryLabelProvider;
import org.eclipse.wst.xml.ui.internal.dialogs.XMLCatalogViewerFilter;

public class SelectXMLCatalogIdPanel
extends Composite {
    protected int catalogEntryType;
    protected boolean doTableSizeHack = false;
    protected StructuredViewer tableViewer;
    protected ICatalog fXmlCatalog;
    private ViewerFilter fExtensionsFilter;

    public SelectXMLCatalogIdPanel(Composite parent, ICatalog xmlCatalog) {
        super(parent, 0);
        this.fXmlCatalog = xmlCatalog;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 700;
        this.setLayoutData(gd);
        Label label = new Label((Composite)this, 0);
        label.setText(XMLUIMessages._UI_LABEL_XML_CATALOG_COLON);
        this.tableViewer = this.createCatalogViewer(this);
        this.tableViewer.setInput((Object)"dummy");
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    void addXMLCatalogEntries(List<ICatalogEntry> list, ICatalogEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            ICatalogEntry entry = entries[i];
            if (this.catalogEntryType == 0) {
                list.add(entry);
            } else if (this.catalogEntryType == entry.getEntryType()) {
                list.add(entry);
            }
            ++i;
        }
    }

    void processCatalog(List<ICatalogEntry> result, ICatalog catalog) {
        this.addXMLCatalogEntries(result, catalog.getCatalogEntries());
        INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            ICatalog nextCatalog = nextCatalogs[i].getReferencedCatalog();
            if (nextCatalog != null) {
                this.processCatalog(result, nextCatalog);
            }
            ++i;
        }
    }

    protected StructuredViewer createCatalogViewer(Composite parent) {
        String[] columnProperties = new String[]{XMLUIMessages._UI_LABEL_KEY, XMLUIMessages._UI_LABEL_URI};
        FilteredTree viewerCreator = new FilteredTree(parent, 67584, new PatternFilter(), true, true);
        viewerCreator.getPatternFilter().setIncludeLeadingWildcard(true);
        viewerCreator.getViewer().setContentProvider((IContentProvider)new XMLCatalogEntryContentProvider());
        viewerCreator.getViewer().setLabelProvider((IBaseLabelProvider)new XMLCatalogEntryLabelProvider());
        viewerCreator.getViewer().getTree().setLinesVisible(true);
        viewerCreator.getViewer().getTree().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnProperties.length) {
            TreeColumn column = new TreeColumn(viewerCreator.getViewer().getTree(), i);
            column.setText(columnProperties[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
            ++i;
        }
        viewerCreator.getViewer().getTree().setLayout((Layout)layout);
        viewerCreator.getViewer().getTree().setLinesVisible(false);
        viewerCreator.getViewer().setColumnProperties(columnProperties);
        return viewerCreator.getViewer();
    }

    public String getId() {
        ICatalogEntry entry = this.getXMLCatalogEntry();
        return entry != null ? entry.getKey() : null;
    }

    public StructuredViewer getCatalogViewer() {
        return this.tableViewer;
    }

    public String getURI() {
        ICatalogEntry entry = this.getXMLCatalogEntry();
        return entry != null ? entry.getURI() : null;
    }

    public ICatalogEntry getXMLCatalogEntry() {
        Object selectedObject;
        ICatalogEntry result = null;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof ICatalogEntry) {
            result = (ICatalogEntry)selectedObject;
        }
        return result;
    }

    public void setCatalogEntryType(int catalogEntryType) {
        this.catalogEntryType = catalogEntryType;
        this.tableViewer.refresh();
    }

    void setFilterExtensions(String[] extensions) {
        if (this.fExtensionsFilter != null) {
            this.getCatalogViewer().removeFilter(this.fExtensionsFilter);
        }
        this.fExtensionsFilter = new XMLCatalogViewerFilter(extensions);
        this.getCatalogViewer().addFilter(this.fExtensionsFilter);
    }
}

