/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class TaskParser {
    private final Map<Integer, Integer> fTidToPid = new TreeMap<Integer, Integer>();
    private final Map<Integer, Long> fPidToSid = new TreeMap<Integer, Long>();
    private final Map<Integer, String> fPidToExecName = new TreeMap<Integer, String>();

    public TaskParser(File file) throws IOException {
        LineIterator iter = FileUtils.lineIterator((File)file);
        while (iter.hasNext()) {
            String[] pair;
            String line = iter.next();
            String[] tuples = line.split(" ");
            if (tuples[0].equals("SESS")) {
                pair = tuples[2].split("=");
                int pid = Integer.parseInt(pair[1]);
                pair = tuples[3].split("=");
                long sid = Long.parseUnsignedLong(pair[1], 16);
                String execName = tuples[4].split("=")[1];
                this.fPidToSid.put(pid, sid);
                this.fPidToExecName.put(pid, execName);
            }
            if (!tuples[0].equals("TASK")) continue;
            pair = tuples[2].split("=");
            int tid = Integer.parseInt(pair[1]);
            pair = tuples[3].split("=");
            int pid = Integer.parseInt(pair[1]);
            this.fTidToPid.put(tid, pid);
        }
    }

    public Collection<Integer> getTids() {
        return this.fTidToPid.keySet();
    }

    public int getPid(int tid) {
        return this.fTidToPid.getOrDefault(tid, -1);
    }

    public String getExecName(int tid) {
        return this.fPidToExecName.get(this.getPid(tid));
    }

    public Long getSessName(int tid) {
        return this.fPidToSid.get(this.getPid(tid));
    }
}

