/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

public class InputStreamMonitor {
    private final OutputStream fStream;
    private final Queue<byte[]> fQueue;
    private volatile Thread fThread;
    private final Object fLock;
    private volatile boolean fClosed = false;
    private final Charset fCharset;

    public InputStreamMonitor(OutputStream stream) {
        this(stream, (Charset)null);
    }

    public InputStreamMonitor(OutputStream stream, Charset charset) {
        this.fStream = stream;
        this.fQueue = new LinkedTransferQueue<byte[]>();
        this.fLock = new Object();
        this.fCharset = charset;
    }

    @Deprecated
    public InputStreamMonitor(OutputStream stream, String encoding) {
        this(stream, Charset.forName(encoding));
    }

    public void write(String text) {
        this.write(this.fCharset == null ? text.getBytes() : text.getBytes(this.fCharset));
    }

    public void write(byte[] data, int offset, int length) {
        this.write(Arrays.copyOfRange(data, offset, offset + length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] copy) {
        if (this.fClosed) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fQueue.offer(copy);
            this.fLock.notifyAll();
        }
    }

    public void startMonitoring() {
        this.startMonitoring("Input Stream Monitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring(String threadName) {
        InputStreamMonitor inputStreamMonitor = this;
        synchronized (inputStreamMonitor) {
            if (this.fThread == null) {
                this.fThread = new Thread(this::write, threadName);
                this.fThread.setDaemon(true);
                this.fThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Thread thread = null;
        InputStreamMonitor inputStreamMonitor = this;
        synchronized (inputStreamMonitor) {
            thread = this.fThread;
            this.fThread = null;
        }
        if (thread != null) {
            thread.interrupt();
        }
    }

    private void write() {
        try {
            try {
                while (this.fThread != null) {
                    this.writeNext();
                }
            }
            finally {
                if (!this.fClosed) {
                    this.fClosed = true;
                    this.fStream.close();
                }
            }
        }
        catch (IOException e) {
            this.fQueue.clear();
            DebugPlugin.log((IStatus)Status.warning((String)("Error writing to '" + Thread.currentThread().getName() + "': " + e.getMessage()), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNext() throws IOException {
        while (!this.fQueue.isEmpty() && !this.fClosed) {
            byte[] data = this.fQueue.poll();
            this.fStream.write(data);
            this.fStream.flush();
        }
        try {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fQueue.isEmpty()) {
                    this.fLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void closeInputStream() throws IOException {
        if (this.fClosed) {
            throw new IOException();
        }
        this.fClosed = true;
        this.fStream.close();
    }
}

