/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.tokenizer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.ease.ui.completion.tokenizer.Bracket;

public class BracketMatcher {
    private static final char OPEN = '(';
    private static final char CLOSE = ')';
    private final List<Bracket> fBrackets = new ArrayList<Bracket>();

    public BracketMatcher(String input) {
        int pos = 0;
        while (pos < input.length()) {
            char c = input.charAt(pos);
            if (c == '(') {
                this.fBrackets.add(0, new Bracket(pos, -1));
            } else if (c == ')') {
                for (Bracket bracket : this.fBrackets) {
                    if (bracket.getEnd() != -1) continue;
                    bracket.setEnd(pos);
                    break;
                }
            }
            ++pos;
        }
    }

    public List<Bracket> getBrackets() {
        return this.fBrackets;
    }

    public boolean hasOpenBrackets() {
        return this.getBrackets().stream().anyMatch(b -> b.getEnd() == -1);
    }

    public List<Bracket> getOpenBrackets() {
        return this.getBrackets().stream().filter(b -> b.getEnd() == -1).collect(Collectors.toList());
    }
}

