/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontRegistry;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;

final class ScalingSWTFontRegistry
implements SWTFontRegistry {
    private static FontData KEY_SYSTEM_FONTS = new FontData();
    private Map<Long, ScaledFontContainer> fontHandleMap = new HashMap<Long, ScaledFontContainer>();
    private Map<FontData, ScaledFontContainer> fontKeyMap = new HashMap<FontData, ScaledFontContainer>();
    private Device device;

    ScalingSWTFontRegistry(Device device) {
        this.device = device;
    }

    @Override
    public Font getSystemFont(int zoom) {
        ScaledFontContainer container = this.getOrCreateBaseSystemFontContainer(this.device);
        Font systemFont = container.getScaledFont(zoom);
        if (systemFont != null) {
            return systemFont;
        }
        long systemFontHandle = this.createSystemFont(zoom);
        systemFont = Font.win32_new(this.device, systemFontHandle, zoom);
        container.addScaledFont(zoom, systemFont);
        return systemFont;
    }

    private ScaledFontContainer getOrCreateBaseSystemFontContainer(Device device) {
        ScaledFontContainer systemFontContainer = this.fontKeyMap.get(KEY_SYSTEM_FONTS);
        if (systemFontContainer == null) {
            int targetZoom = DPIUtil.mapDPIToZoom(device.getDPI().x);
            long systemFontHandle = this.createSystemFont(targetZoom);
            Font systemFont = Font.win32_new(device, systemFontHandle);
            systemFontContainer = new ScaledFontContainer(systemFont, targetZoom);
            this.fontHandleMap.put(systemFont.handle, systemFontContainer);
            this.fontKeyMap.put(KEY_SYSTEM_FONTS, systemFontContainer);
        }
        return systemFontContainer;
    }

    private long createSystemFont(int targetZoom) {
        long hFont = 0L;
        NONCLIENTMETRICS info = new NONCLIENTMETRICS();
        info.cbSize = NONCLIENTMETRICS.sizeof;
        if (ScalingSWTFontRegistry.fetchSystemParametersInfo(info, targetZoom)) {
            LOGFONT logFont = info.lfMessageFont;
            hFont = OS.CreateFontIndirect(logFont);
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(17);
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(13);
        }
        return hFont;
    }

    private static boolean fetchSystemParametersInfo(NONCLIENTMETRICS info, int targetZoom) {
        if (OS.WIN32_BUILD >= 14393) {
            return OS.SystemParametersInfoForDpi(41, NONCLIENTMETRICS.sizeof, info, 0, DPIUtil.mapZoomToDPI(targetZoom));
        }
        return OS.SystemParametersInfo(41, 0, info, 0);
    }

    @Override
    public Font getFont(FontData fontData, int zoom) {
        ScaledFontContainer container;
        if (this.fontKeyMap.containsKey(fontData)) {
            container = this.fontKeyMap.get(fontData);
        } else {
            int calculatedZoom = this.computeZoom(fontData);
            Font newFont = Font.win32_new(this.device, fontData, calculatedZoom);
            container = new ScaledFontContainer(newFont, calculatedZoom);
            this.fontHandleMap.put(newFont.handle, container);
            this.fontKeyMap.put(fontData, container);
        }
        return this.getOrCreateFont(container, zoom);
    }

    @Override
    public void dispose() {
        for (Map.Entry<FontData, ScaledFontContainer> fontContainerEntry : this.fontKeyMap.entrySet()) {
            if (KEY_SYSTEM_FONTS.equals(fontContainerEntry.getKey())) continue;
            ScaledFontContainer scaledFontContainer = fontContainerEntry.getValue();
            for (Font font : scaledFontContainer.scaledFonts.values()) {
                font.dispose();
            }
        }
        this.fontKeyMap.clear();
    }

    private Font getOrCreateFont(ScaledFontContainer container, int zoom) {
        Font scaledFont = container.getScaledFont(zoom);
        if (scaledFont == null) {
            scaledFont = container.scaleFont(zoom);
            this.fontHandleMap.put(scaledFont.handle, container);
            this.fontKeyMap.put(scaledFont.getFontData()[0], container);
        }
        return scaledFont;
    }

    private int computeZoom(FontData fontData) {
        int dpi = this.device.getDPI().x;
        int pixelsAtPrimaryMonitorZoom = this.computePixels(fontData.height);
        int value = DPIUtil.mapDPIToZoom(dpi) * fontData.data.lfHeight / pixelsAtPrimaryMonitorZoom;
        return value;
    }

    private int computePixels(int zoom, FontData fontData) {
        int dpi = this.device.getDPI().x;
        int adjustedLogFontHeight = this.computePixels(fontData.height);
        int primaryZoom = DPIUtil.mapDPIToZoom(dpi);
        if (zoom != primaryZoom) {
            adjustedLogFontHeight = (int)((float)adjustedLogFontHeight * (1.0f * (float)zoom / (float)primaryZoom));
        }
        return adjustedLogFontHeight;
    }

    private int computePixels(float height) {
        int dpi = this.device.getDPI().x;
        return -((int)(0.5f + height * (float)dpi / 72.0f));
    }

    private class ScaledFontContainer {
        private Font baseFont;
        private Map<Integer, Font> scaledFonts = new HashMap<Integer, Font>();

        ScaledFontContainer(Font baseFont, int fontZoom) {
            this.baseFont = baseFont;
            this.scaledFonts.put(fontZoom, baseFont);
        }

        private Font getScaledFont(int targetZoom) {
            if (this.scaledFonts.containsKey(targetZoom)) {
                Font font = this.scaledFonts.get(targetZoom);
                if (font.isDisposed()) {
                    this.scaledFonts.remove(targetZoom);
                    return null;
                }
                return font;
            }
            return null;
        }

        private Font scaleFont(int zoom) {
            FontData fontData = this.baseFont.getFontData()[0];
            fontData.data.lfHeight = ScalingSWTFontRegistry.this.computePixels(zoom, fontData);
            Font scaledFont = Font.win32_new(ScalingSWTFontRegistry.this.device, fontData, zoom);
            this.addScaledFont(zoom, scaledFont);
            return scaledFont;
        }

        private void addScaledFont(int targetZoom, Font scaledFont) {
            this.scaledFonts.put(targetZoom, scaledFont);
        }
    }
}

