/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class FlameChartEntryModel
extends TimeGraphEntryModel {
    private final EntryType fEntryType;
    private final int fDepth;
    private @Nullable HostThread fHostThread;

    public FlameChartEntryModel(long id, long parentId, List<String> name, long startTime, long endTime, EntryType entryType) {
        super(id, parentId, name, startTime, endTime);
        this.fEntryType = entryType;
        this.fDepth = -1;
    }

    public FlameChartEntryModel(long elementId, long parentId, List<String> name, long startTime, long endTime, EntryType entryType, int depth, @Nullable HostThread hostThread) {
        super(elementId, parentId, name, startTime, endTime);
        this.fEntryType = entryType;
        this.fDepth = depth;
        this.fHostThread = hostThread;
    }

    public EntryType getEntryType() {
        return this.fEntryType;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FlameChartEntryModel)) {
            return false;
        }
        FlameChartEntryModel other = (FlameChartEntryModel)((Object)obj);
        return this.fEntryType == other.fEntryType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fEntryType});
    }

    public String toString() {
        return super.toString() + " " + this.fEntryType.toString();
    }

    public Multimap<String, Object> getMetadata() {
        HashMultimap map = HashMultimap.create();
        HostThread hostThread = this.fHostThread;
        if (hostThread != null) {
            map.put((Object)OsStrings.tid(), (Object)hostThread.getTid());
            map.put((Object)"hostId", (Object)hostThread.getHost());
        }
        return map;
    }

    public static class Builder {
        private final long fId;
        private final long fParentId;
        private final long fStartTime;
        private final String fName;
        private final EntryType fEntryType;
        private final int fDepth;
        private long fEndTime;
        private @Nullable HostThread fHostThread;

        public Builder(long id, long parentId, String name, long start, EntryType entryType, int depth) {
            this.fId = id;
            this.fParentId = parentId;
            this.fName = name;
            this.fStartTime = start;
            this.fEntryType = entryType;
            this.fDepth = depth;
            this.fEndTime = start;
            this.fHostThread = null;
        }

        public long getId() {
            return this.fId;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public void setEndTime(long endTime) {
            this.fEndTime = Long.max(this.fEndTime, endTime);
        }

        public void setHostThread(@Nullable HostThread hostThread) {
            this.fHostThread = hostThread;
        }

        public FlameChartEntryModel build() {
            return new FlameChartEntryModel(this.fId, this.fParentId, Collections.singletonList(this.fName), this.fStartTime, this.fEndTime, this.fEntryType, this.fDepth, this.fHostThread);
        }

        public long getParentId() {
            return this.fParentId;
        }

        public int getDepth() {
            return this.fDepth;
        }
    }

    public static enum EntryType {
        TRACE,
        LEVEL,
        FUNCTION,
        KERNEL;

    }
}

