/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;

public abstract class AbstractXmlViewInfo {
    private final String fViewId;
    private @Nullable String fSubsectionName;

    public AbstractXmlViewInfo(String viewId) {
        this.fViewId = viewId;
        this.fSubsectionName = null;
    }

    public void setName(@NonNull String name) {
        this.fSubsectionName = name;
    }

    protected @Nullable String getName() {
        return this.fSubsectionName;
    }

    protected IDialogSettings getPersistentPropertyStore() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.fViewId);
        if (section == null && (section = settings.addNewSection(this.fViewId)) == null) {
            throw new IllegalStateException("The persistent property section could not be added " + this.fViewId);
        }
        if (this.fSubsectionName == null) {
            return section;
        }
        IDialogSettings subSection = section.getSection(this.fSubsectionName);
        if (subSection == null && (subSection = section.addNewSection(this.fSubsectionName)) == null) {
            throw new IllegalStateException("The persistent property section could not be added: " + this.fSubsectionName);
        }
        return subSection;
    }

    public abstract void setViewData(@NonNull String var1);

    protected abstract void savePersistentData();
}

