/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.py4j.internal.ui;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.ease.lang.python.py4j.internal.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Py4JPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new FileFieldEditor("org.eclipse.ease.lang.python.py4j.INTERPRETER", "Python location:", false, 0, this.getFieldEditorParent()){
            private Button variablesButton;
            {
                this.setErrorMessage("Python location must be absolute path to python, or name of executable to launch from System PATH");
            }

            public int getNumberOfControls() {
                return 4;
            }

            protected void variablesPressed() {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getTextControl().getShell());
                if (dialog.open() == 0) {
                    this.getTextControl().insert(dialog.getVariableExpression());
                    this.valueChanged();
                }
            }

            protected Button getVariablesControl(Composite parent) {
                if (this.variablesButton == null) {
                    this.variablesButton = new Button(parent, 8);
                    this.variablesButton.setText("Variables...");
                    this.variablesButton.setFont(parent.getFont());
                    this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            this.variablesPressed();
                        }
                    });
                    this.variablesButton.addDisposeListener(event -> {
                        Button button = this.variablesButton = null;
                    });
                } else {
                    this.checkParent((Control)this.variablesButton, parent);
                }
                return this.variablesButton;
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns - 1);
                this.variablesButton = this.getVariablesControl(parent);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                int widthHint = this.convertHorizontalDLUsToPixels((Control)this.variablesButton, 61);
                gd.widthHint = Math.max(widthHint, this.variablesButton.computeSize((int)-1, (int)-1, (boolean)true).x);
                this.variablesButton.setLayoutData((Object)gd);
            }

            protected boolean checkState() {
                String resolvedPath;
                String msg = null;
                String info = null;
                String rawPath = this.getTextControl().getText();
                rawPath = rawPath != null ? rawPath.trim() : "";
                IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    resolvedPath = variableManager.performStringSubstitution(rawPath);
                }
                catch (CoreException e) {
                    msg = e.getLocalizedMessage();
                    resolvedPath = "";
                }
                if (msg == null) {
                    if (resolvedPath.isEmpty()) {
                        msg = rawPath.isEmpty() ? this.getErrorMessage() : "Variable used in Python location has not resolved to anything";
                    } else {
                        File file = new File(resolvedPath);
                        if (file.isFile() && file.isAbsolute()) {
                            if (!resolvedPath.equals(rawPath)) {
                                info = "'" + resolvedPath + "' will be used as the Python location.";
                            }
                        } else if (file.isDirectory() || resolvedPath.contains("/") || resolvedPath.contains("\\")) {
                            msg = String.valueOf(this.getErrorMessage()) + ". The current setting is resolving to '" + resolvedPath + "'.";
                        } else {
                            info = "'" + resolvedPath + "' will be launched from PATH unless an absolute location is provided.";
                        }
                    }
                }
                if (msg != null) {
                    this.showErrorMessage(msg);
                    return false;
                }
                if (this.doCheckState()) {
                    this.clearErrorMessage();
                    this.getPage().setMessage(null);
                    if (info != null) {
                        this.getPage().setMessage(info, 1);
                    }
                    return true;
                }
                msg = this.getErrorMessage();
                if (msg != null) {
                    this.showErrorMessage(msg);
                }
                return false;
            }
        });
        Composite fieldEditorParent = this.getFieldEditorParent();
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("org.eclipse.ease.lang.python.py4j.IGNORE_PYTHON_ENV_VARIABLES", "Ignore all PYTHON* environment variables when launching Python", fieldEditorParent);
        booleanFieldEditor.getDescriptionControl(fieldEditorParent).setToolTipText("Ignore all PYTHON* environment variables, e.g. PYTHONPATH and PYTHONHOME, that might be set. (-E command line option to Python)");
        this.addField((FieldEditor)booleanFieldEditor);
    }
}

