/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class UIModelManipulator {
    public static String getIDForName(String name) {
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        IWorkbench workbench = (IWorkbench)PlatformUI.getWorkbench().getService(IWorkbench.class);
        MApplication mApplication = workbench.getApplication();
        List descriptors = modelService.findElements((MUIElement)mApplication, null, MPartDescriptor.class, null);
        for (MPartDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getElementId()) && !name.equals(descriptor.getLabel())) continue;
            return descriptor.getElementId();
        }
        List partDescriptors = modelService.findElements((MUIElement)mApplication, null, MPart.class, null);
        for (MPart descriptor : partDescriptors) {
            if (!name.equals(descriptor.getElementId()) && !name.equals(descriptor.getLabel())) continue;
            return descriptor.getElementId();
        }
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor[] iViewDescriptorArray = viewRegistry.getViews();
        int n = iViewDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor descriptor = iViewDescriptorArray[n2];
            if (name.equals(descriptor.getId()) || name.equals(descriptor.getLabel())) {
                return descriptor.getId();
            }
            ++n2;
        }
        return null;
    }

    public static MUIElement findElement(String id) {
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        IWorkbench workbench = (IWorkbench)PlatformUI.getWorkbench().getService(IWorkbench.class);
        MApplication mApplication = workbench.getApplication();
        List placeholders = modelService.findElements((MUIElement)mApplication, null, MPlaceholder.class, null);
        MPerspective perspective = UIModelManipulator.getCurrentPerspective();
        for (MPlaceholder placeholder : placeholders) {
            if (!placeholder.getElementId().equals(id) || !UIModelManipulator.perspectiveContains(perspective, (MUIElement)placeholder)) continue;
            return placeholder;
        }
        List parts = modelService.findElements((MUIElement)mApplication, null, MPart.class, null);
        for (MPart part : parts) {
            if (!part.getElementId().equals(id) || !UIModelManipulator.perspectiveContains(perspective, (MUIElement)part)) continue;
            return part;
        }
        return null;
    }

    private static boolean perspectiveContains(MPerspective perspective, MUIElement uiElement) {
        if (uiElement.getParent() == null) {
            return false;
        }
        if (perspective.equals(uiElement.getParent())) {
            return true;
        }
        return UIModelManipulator.perspectiveContains(perspective, (MUIElement)uiElement.getParent());
    }

    public static MPerspective getCurrentPerspective() {
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        IWorkbench workbench = (IWorkbench)PlatformUI.getWorkbench().getService(IWorkbench.class);
        MApplication mApplication = workbench.getApplication();
        List perspectiveStack = modelService.findElements((MUIElement)mApplication, null, MPerspectiveStack.class, null);
        return (MPerspective)((MPerspectiveStack)perspectiveStack.get(0)).getSelectedElement();
    }

    public static MPartSashContainer splitPartStack(MElementContainer<MUIElement> stack, int position) {
        MPartSashContainer newSashContainer = MBasicFactory.INSTANCE.createPartSashContainer();
        MPartStack newPartStack = MBasicFactory.INSTANCE.createPartStack();
        MElementContainer parentContainer = stack.getParent();
        int stackIndex = parentContainer.getChildren().indexOf(stack);
        parentContainer.getChildren().remove(stack);
        parentContainer.getChildren().add(stackIndex, newSashContainer);
        newSashContainer.setHorizontal(position == 16384 || position == 131072);
        newSashContainer.getChildren().add(newPartStack);
        newSashContainer.getChildren().add(position == 16384 || position == 128 ? 0 : 1, (MPartSashContainerElement)stack);
        return newSashContainer;
    }

    public static void move(MUIElement uiElement, MElementContainer<MUIElement> targetContainer) {
        UIModelManipulator.remove(uiElement);
        UIModelManipulator.add(uiElement, targetContainer);
    }

    private static void add(MUIElement uiElement, MElementContainer<MUIElement> targetContainer) {
        targetContainer.getChildren().add(uiElement);
        if (targetContainer.getChildren().size() == 1) {
            targetContainer.setSelectedElement(uiElement);
        }
    }

    private static void remove(MUIElement uiElement) {
        MElementContainer parent = uiElement.getParent();
        parent.getChildren().remove(uiElement);
        UIModelManipulator.reconcileContainer((MElementContainer<MUIElement>)parent);
    }

    public static void reconcileContainer(MElementContainer<MUIElement> container) {
        if (container.getChildren().isEmpty()) {
            MElementContainer sash = container.getParent();
            if (sash.getChildren().size() == 2) {
                sash.getChildren().remove(container);
                Object widget = container.getWidget();
                if (widget instanceof Control) {
                    ((Control)widget).dispose();
                }
                MUIElement remainingContainer = (MUIElement)sash.getChildren().remove(0);
                MElementContainer sashParent = sash.getParent();
                int sashIndex = sashParent.getChildren().indexOf(sash);
                sashParent.getChildren().remove(sash);
                widget = sash.getWidget();
                if (widget instanceof Control) {
                    ((Control)widget).dispose();
                }
                sashParent.getChildren().add(sashIndex, remainingContainer);
                sashParent.setSelectedElement(remainingContainer);
            }
        } else if (!container.getChildren().contains(container.getSelectedElement())) {
            container.setSelectedElement((MUIElement)container.getChildren().get(0));
        }
    }
}

