/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.analysis;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatEvent;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.UfEventType;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.Uftrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.MultiAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UfCallstackProvider
extends CallStackStateProvider {
    private final ITmfEventAspect<String> fExecAspect;
    private final ITmfEventAspect<Integer> fTidAspect;
    private final ITmfEventAspect<Integer> fPidAspect;

    public UfCallstackProvider(@NonNull ITmfTrace trace) {
        super(trace);
        this.fExecAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, Uftrace.ExecAspect.class), Uftrace.ExecAspect.class);
        this.fTidAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, LinuxTidAspect.class), LinuxTidAspect.class);
        this.fPidAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, Uftrace.PidAspect.class), Uftrace.PidAspect.class);
    }

    public int getVersion() {
        return 2;
    }

    public @NonNull CallStackStateProvider getNewInstance() {
        return new UfCallstackProvider(this.getTrace());
    }

    protected boolean considerEvent(@NonNull ITmfEvent event) {
        return true;
    }

    protected @Nullable Object functionEntry(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Object payload = content.getValue();
        if (payload instanceof DatEvent) {
            DatEvent ev = (DatEvent)payload;
            if (event.getType().equals((Object)UfEventType.ENTRY)) {
                return ev.getAddress();
            }
        }
        return null;
    }

    protected @Nullable Object functionExit(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Object payload = content.getValue();
        if (payload instanceof DatEvent) {
            DatEvent ev = (DatEvent)payload;
            if (event.getType().equals((Object)UfEventType.EXIT)) {
                return ev.getAddress();
            }
        }
        return null;
    }

    protected @Nullable String getProcessName(@NonNull ITmfEvent event) {
        return (String)this.fExecAspect.resolve(event);
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        Integer resolve = (Integer)this.fPidAspect.resolve(event);
        return resolve == null ? -1 : resolve;
    }

    protected long getThreadId(@NonNull ITmfEvent event) {
        Integer resolve = (Integer)this.fTidAspect.resolve(event);
        return resolve == null ? -1L : resolve.longValue();
    }
}

