/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.wizards;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class JaegerRestUtils {
    private static final String SERVICES_ENDPOINT = "services";
    private static final String TRACES_ENDPOINT = "traces";
    private static final String SERVICES_DATA_KEY = "data";
    private static final String SEARCH_END_TIME = "end";
    private static final String NB_TRACES_LIMIT = "limit";
    private static final String LOOKBACK = "lookback";
    private static final String MAX_DURATION = "maxDuration";
    private static final String MIN_DURATION = "minDuration";
    private static final String SERVICE_NAME = "service";
    private static final String SEARCH_START_TIME = "start";
    private static final String TAGS = "tags";

    private JaegerRestUtils() {
    }

    public static String[] fetchServices(String baseUrl) {
        URI uri = UriBuilder.fromUri((String)baseUrl).path(SERVICES_ENDPOINT).build(new Object[0]);
        String response = JaegerRestUtils.jaegerGet(uri.toString());
        Gson gson = new Gson();
        JsonObject jsonResponse = (JsonObject)gson.fromJson(response, JsonObject.class);
        JsonArray servicesArray = jsonResponse.get(SERVICES_DATA_KEY).getAsJsonArray();
        String[] services = new String[servicesArray.size()];
        int i = 0;
        while (i < servicesArray.size()) {
            services[i] = servicesArray.get(i).getAsString();
            ++i;
        }
        return services;
    }

    public static String buildTracesUrl(String baseUrl, String endTime, String limit, String lookback, String maxDuration, String minDuration, String service, String startTime, String tags) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)baseUrl).path(TRACES_ENDPOINT).queryParam(SEARCH_END_TIME, new Object[]{endTime}).queryParam(NB_TRACES_LIMIT, new Object[]{limit}).queryParam(LOOKBACK, new Object[]{lookback}).queryParam(SERVICE_NAME, new Object[]{service}).queryParam(SEARCH_START_TIME, new Object[]{startTime});
        if (!maxDuration.isEmpty()) {
            uriBuilder.queryParam(MAX_DURATION, new Object[]{maxDuration});
        }
        if (!minDuration.isEmpty()) {
            uriBuilder.queryParam(MIN_DURATION, new Object[]{minDuration});
        }
        if (!tags.isEmpty()) {
            try {
                uriBuilder.queryParam(TAGS, new Object[]{URLEncoder.encode(tags, StandardCharsets.UTF_8.name())});
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    public static String fetchJaegerTraces(String url) {
        return JaegerRestUtils.jaegerGet(url);
    }

    private static String jaegerGet(String url) {
        Client client = ClientBuilder.newClient();
        WebTarget resource = client.target(url);
        Invocation.Builder request = resource.request();
        request.accept(new String[]{"application/json"});
        try {
            return (String)request.get(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean jaegerCheckConnection(String url) {
        Client client = ClientBuilder.newClient();
        WebTarget resource = client.target(url);
        Invocation.Builder request = resource.request();
        try {
            int status = request.get().getStatus();
            return Response.Status.fromStatusCode((int)status) == Response.Status.OK;
        }
        catch (Exception e) {
            return false;
        }
    }
}

