/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis;

import java.util.regex.Pattern;

public interface IOtf2Constants {
    public static final Pattern OTF2_EVENT_NAME_PATTERN = Pattern.compile("^(?<type>.*)_(?<name>.*)");
    public static final String EDGES = "Edges";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String OTF2_TYPE_GROUP = "type";
    public static final String OTF2_NAME_GROUP = "name";
    public static final String OTF2_GLOBAL_DEFINITION = "GlobalDef";
    public static final String OTF2_EVENT = "Event";
    public static final String OTF2_STRING = "String";
    public static final String OTF2_REGION = "Region";
    public static final String OTF2_LOCATION_GROUP = "LocationGroup";
    public static final String OTF2_LOCATION = "Location";
    public static final String OTF2_SYSTEM_TREE_NODE = "SystemTreeNode";
    public static final String OTF2_COMM = "Comm";
    public static final String OTF2_GROUP = "Group";
    public static final String OTF2_GROUP_MEMBER = "GroupMember";
    public static final String OTF2_ENTER = "Enter";
    public static final String OTF2_LEAVE = "Leave";
    public static final String OTF2_MPI_SEND = "MpiSend";
    public static final String OTF2_MPI_ISEND = "MpiIsend";
    public static final String OTF2_MPI_RECV = "MpiRecv";
    public static final String OTF2_MPI_IRECV = "MpiIrecv";
    public static final String OTF2_MPI_COLLECTIVE_BEGIN = "MpiCollectiveBegin";
    public static final String OTF2_MPI_COLLECTIVE_END = "MpiCollectiveEnd";
    public static final String OTF2_STRING_REFERENCE = "stringRef";
    public static final String OTF2_STRING_VALUE = "stringValue";
    public static final String OTF2_REGION_REFERENCE = "regionRef";
    public static final String OTF2_LOCATION_REFERENCE = "locationRef";
    public static final String OTF2_LOCATION_GROUP_REFERENCE = "locationGroupRef";
    public static final String OTF2_SYSTEM_TREE_NODE_REFERENCE = "systemTreeNodeRef";
    public static final String OTF2_GROUP_REFERENCE = "groupRef";
    public static final String OTF2_NUMBER_OF_MEMBERS = "numberOfMembers";
    public static final String OTF2_RANK = "rank";
    public static final String OTF2_MEMBERS = "members";
    public static final String OTF2_COMMUNICATOR_REFERENCE = "commRef";
    public static final String OTF2_NAME = "name";
    public static final String OTF2_COMMUNICATOR = "communicator";
    public static final String OTF2_SENDER = "sender";
    public static final String OTF2_RECEIVER = "receiver";
    public static final String OTF2_MESSAGE_TAG = "msgTag";
    public static final String OTF2_REQUEST_ID = "requestID";
    public static final String OTF2_COLLECTIVE_OPERATION = "collectiveOp";
    public static final String OTF2_ROOT = "root";

    public static CollectiveOperation getOperation(int operationCode) {
        switch (operationCode) {
            case 0: {
                return CollectiveOperation.BARRIER;
            }
            case 1: {
                return CollectiveOperation.BCAST;
            }
            case 2: {
                return CollectiveOperation.GATHER;
            }
            case 3: {
                return CollectiveOperation.GATHERV;
            }
            case 4: {
                return CollectiveOperation.SCATTER;
            }
            case 5: {
                return CollectiveOperation.SCATTERV;
            }
            case 6: {
                return CollectiveOperation.ALLGATHER;
            }
            case 7: {
                return CollectiveOperation.ALLGATHERV;
            }
            case 8: {
                return CollectiveOperation.ALLTOALL;
            }
            case 9: {
                return CollectiveOperation.ALLTOALLV;
            }
            case 10: {
                return CollectiveOperation.ALLTOALLW;
            }
            case 11: {
                return CollectiveOperation.ALLREDUCE;
            }
            case 12: {
                return CollectiveOperation.REDUCE;
            }
            case 13: {
                return CollectiveOperation.REDUCE_SCATTER;
            }
            case 14: {
                return CollectiveOperation.SCAN;
            }
            case 15: {
                return CollectiveOperation.EXSCAN;
            }
            case 16: {
                return CollectiveOperation.REDUCE_SCATTER_BLOCK;
            }
            case 17: {
                return CollectiveOperation.CREATE_HANDLE;
            }
            case 18: {
                return CollectiveOperation.DESTROY_HANDLE;
            }
            case 19: {
                return CollectiveOperation.ALLOCATE;
            }
            case 20: {
                return CollectiveOperation.DEALLOCATE;
            }
            case 21: {
                return CollectiveOperation.CREATE_HANDLE_AND_ALLOCATE;
            }
            case 22: {
                return CollectiveOperation.DESTROY_HANDLE_AND_DEALLOCATE;
            }
        }
        return CollectiveOperation.UNKNOWN_OPERATION;
    }

    public static enum CollectiveOperation {
        BARRIER,
        BCAST,
        GATHER,
        GATHERV,
        SCATTER,
        SCATTERV,
        ALLGATHER,
        ALLGATHERV,
        ALLTOALL,
        ALLTOALLV,
        ALLTOALLW,
        ALLREDUCE,
        REDUCE,
        REDUCE_SCATTER,
        SCAN,
        EXSCAN,
        REDUCE_SCATTER_BLOCK,
        CREATE_HANDLE,
        DESTROY_HANDLE,
        ALLOCATE,
        DEALLOCATE,
        CREATE_HANDLE_AND_ALLOCATE,
        DESTROY_HANDLE_AND_DEALLOCATE,
        UNKNOWN_OPERATION;

    }
}

