/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis;

import java.util.regex.Pattern;

public interface IOtf2Constants {
    public static final Pattern OTF2_EVENT_NAME_PATTERN = Pattern.compile("^(?<type>.*)_(?<name>.*)");
    public static final String EDGES = "Edges";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String OTF2_TYPE_GROUP = "type";
    public static final String OTF2_NAME_GROUP = "name";
    public static final String OTF2_GLOBAL_DEFINITION = "GlobalDef";
    public static final String OTF2_EVENT = "Event";
    public static final int OTF2_UNDEFINED_UINT8 = 255;
    public static final long OTF2_UNDEFINED_UINT32 = 0xFFFFFFFFL;
    public static final long OTF2_UNDEFINED_UINT64 = -1L;
    public static final long OTF2_UNDEFINED_INT64 = Long.MIN_VALUE;
    public static final long OTF2_UNKNOWN_STRING = 0xFFFFFFFFL;
    public static final long OTF2_UNDEFINED_SYSTEM_TREE_NODE = 0xFFFFFFFFL;
    public static final long OTF2_UNKNOWN_SYSTEM_TREE_NODE = 0xFFFFFFFFL;
    public static final long OTF2_UNKNOWN_LOCATION_GROUP = 0xFFFFFFFFL;
    public static final long OTF2_UNKNOWN_LOCATION = -1L;
    public static final int OTF2_UNKNOWN_LOCATION_GROUP_TYPE = 255;
    public static final long OTF2_UNKNOWN_METRIC_MEMBER = 0xFFFFFFFFL;
    public static final int OTF2_UNKNOWN_METRIC_TYPE = 255;
    public static final int OTF2_UNKNOWN_METRIC_MODE = 255;
    public static final int OTF2_UNKNOWN_VALUE_TYPE = 255;
    public static final int OTF2_UNKNOWN_BASE = 255;
    public static final long OTF2_UNKNOWN_EXPONENT = Long.MIN_VALUE;
    public static final long OTF2_UNKNOWN_METRIC_CLASS = 0xFFFFFFFFL;
    public static final int BINARY_BASE_CODE = 0;
    public static final int DECIMAL_BASE_CODE = 1;
    public static final int METRIC_MODE_MASK = 15;
    public static final int OTF2_METRIC_ABSOLUTE_POINT = 4;
    public static final int OTF2_METRIC_ABSOLUTE_NEXT = 6;
    public static final int OTF2_TYPE_INT64 = 4;
    public static final int OTF2_TYPE_UINT64 = 8;
    public static final int OTF2_TYPE_DOUBLE = 10;

    public static CollectiveOperation getOperation(int operationCode) {
        switch (operationCode) {
            case 0: {
                return CollectiveOperation.BARRIER;
            }
            case 1: {
                return CollectiveOperation.BCAST;
            }
            case 2: {
                return CollectiveOperation.GATHER;
            }
            case 3: {
                return CollectiveOperation.GATHERV;
            }
            case 4: {
                return CollectiveOperation.SCATTER;
            }
            case 5: {
                return CollectiveOperation.SCATTERV;
            }
            case 6: {
                return CollectiveOperation.ALLGATHER;
            }
            case 7: {
                return CollectiveOperation.ALLGATHERV;
            }
            case 8: {
                return CollectiveOperation.ALLTOALL;
            }
            case 9: {
                return CollectiveOperation.ALLTOALLV;
            }
            case 10: {
                return CollectiveOperation.ALLTOALLW;
            }
            case 11: {
                return CollectiveOperation.ALLREDUCE;
            }
            case 12: {
                return CollectiveOperation.REDUCE;
            }
            case 13: {
                return CollectiveOperation.REDUCE_SCATTER;
            }
            case 14: {
                return CollectiveOperation.SCAN;
            }
            case 15: {
                return CollectiveOperation.EXSCAN;
            }
            case 16: {
                return CollectiveOperation.REDUCE_SCATTER_BLOCK;
            }
            case 17: {
                return CollectiveOperation.CREATE_HANDLE;
            }
            case 18: {
                return CollectiveOperation.DESTROY_HANDLE;
            }
            case 19: {
                return CollectiveOperation.ALLOCATE;
            }
            case 20: {
                return CollectiveOperation.DEALLOCATE;
            }
            case 21: {
                return CollectiveOperation.CREATE_HANDLE_AND_ALLOCATE;
            }
            case 22: {
                return CollectiveOperation.DESTROY_HANDLE_AND_DEALLOCATE;
            }
        }
        return CollectiveOperation.UNKNOWN_OPERATION;
    }

    public static enum CollectiveOperation {
        BARRIER,
        BCAST,
        GATHER,
        GATHERV,
        SCATTER,
        SCATTERV,
        ALLGATHER,
        ALLGATHERV,
        ALLTOALL,
        ALLTOALLV,
        ALLTOALLW,
        ALLREDUCE,
        REDUCE,
        REDUCE_SCATTER,
        SCAN,
        EXSCAN,
        REDUCE_SCATTER_BLOCK,
        CREATE_HANDLE,
        DESTROY_HANDLE,
        ALLOCATE,
        DEALLOCATE,
        CREATE_HANDLE_AND_ALLOCATE,
        DESTROY_HANDLE_AND_DEALLOCATE,
        UNKNOWN_OPERATION;

    }
}

