/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsLocation;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsLocationGroup;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsNodeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsSystemTreeNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.Otf2FlowsAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2FlowsStateProvider
extends AbstractOtf2StateProvider {
    private static int VERSION_NUMBER = 1;
    private final FlowsNodeMap<Long, FlowsLocation> fMapLocation = new FlowsNodeMap();
    private final FlowsNodeMap<Long, FlowsLocationGroup> fMapLocationGroup = new FlowsNodeMap();
    private final FlowsNodeMap<Long, FlowsSystemTreeNode> fMapSystemTreeNode = new FlowsNodeMap();
    private boolean initialized = false;

    public Otf2FlowsStateProvider(ITmfTrace trace) {
        super(trace, Otf2FlowsAnalysis.getFullAnalysisId());
    }

    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                this.processLocationDefinition(event);
                break;
            }
            case "LocationGroup": {
                this.processLocationGroupDefinition(event);
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            case "SystemTreeNode": {
                this.processSystemTreeNodeDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processLocationDefinition(ITmfEvent event) {
        FlowsLocation location = new FlowsLocation(event);
        this.fMapLocation.put(location.getId(), location);
    }

    private void processLocationGroupDefinition(ITmfEvent event) {
        FlowsLocationGroup locationGroup = new FlowsLocationGroup(event);
        this.fMapLocationGroup.put(locationGroup.getId(), locationGroup);
    }

    private void processSystemTreeNodeDefinition(ITmfEvent event) {
        FlowsSystemTreeNode systemTreeNode = new FlowsSystemTreeNode(event);
        this.fMapSystemTreeNode.put(systemTreeNode.getId(), systemTreeNode);
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        if (!this.initialized) {
            for (FlowsSystemTreeNode systemTreeNode : this.fMapSystemTreeNode.values()) {
                if (systemTreeNode == null) continue;
                systemTreeNode.initializeQuarks(ssb, this.fMapSystemTreeNode, this.getStringId());
            }
            for (FlowsLocationGroup locationGroup : this.fMapLocationGroup.values()) {
                if (locationGroup == null) continue;
                locationGroup.initializeQuarks(ssb, this.fMapSystemTreeNode, this.getStringId());
            }
            for (FlowsLocation location : this.fMapLocation.values()) {
                if (location == null) continue;
                location.initializeQuarks(ssb, this.fMapLocationGroup, this.getStringId());
            }
            this.initialized = true;
        }
        switch (name) {
            case "Enter": {
                this.processEnter(event);
                break;
            }
            case "Leave": {
                this.processLeave(ssb, event);
                break;
            }
            case "MpiSend": {
                this.processMpiSend(event);
                break;
            }
            case "MpiRecv": {
                this.processMpiRecv(event);
                break;
            }
            case "MpiCollectiveEnd": {
                this.processMpiCollectiveCommunication(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processEnter(ITmfEvent event) {
        Long locationId = Otf2FlowsStateProvider.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        location.setLatestEnteredTimestamp(event.getTimestamp().toNanos());
    }

    private void processLeave(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        Long locationId = Otf2FlowsStateProvider.getLocationId(event);
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        location.processLeave(ssb, event.getTimestamp().toNanos());
    }

    private void processMpiSend(ITmfEvent event) {
        Long locationId = Otf2FlowsStateProvider.getLocationId(event);
        ITmfEventField content = event.getContent();
        Long messageLength = (Long)content.getFieldValue(Long.class, new String[]{"msgLength"});
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null || messageLength == null) {
            return;
        }
        location.updateOutputMessageSize(messageLength);
    }

    private void processMpiRecv(ITmfEvent event) {
        Long locationId = Otf2FlowsStateProvider.getLocationId(event);
        ITmfEventField content = event.getContent();
        Long messageLength = (Long)content.getFieldValue(Long.class, new String[]{"msgLength"});
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null || messageLength == null) {
            return;
        }
        location.updateInputMessageSize(messageLength);
    }

    private void processMpiCollectiveCommunication(ITmfEvent event) {
        Long locationId = Otf2FlowsStateProvider.getLocationId(event);
        ITmfEventField content = event.getContent();
        Long receivedMessageLength = (Long)content.getFieldValue(Long.class, new String[]{"sizeReceived"});
        Long sentMessageLength = (Long)content.getFieldValue(Long.class, new String[]{"sizeSent"});
        FlowsLocation location = (FlowsLocation)this.fMapLocation.get(locationId);
        if (location == null || receivedMessageLength == null || sentMessageLength == null) {
            return;
        }
        location.updateInputMessageSize(receivedMessageLength);
        location.updateOutputMessageSize(sentMessageLength);
    }
}

