/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.analysis;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class TmfScriptAnalysis
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    public static final String ID = "org.eclipse.tracecompass.incubator.scripting.analysis";
    private static final String SUPP_FOLDER = "scripts";
    private static final String STATE_SYSTEM_FOLDER = "stateSystem";
    private static final int QUEUE_SIZE = 10000;
    private final Map<String, ITmfStateSystem> fStateSystems = new HashMap<String, ITmfStateSystem>();

    private Path getStateSystemFolder() {
        ITmfTrace trace = Objects.requireNonNull(this.getTrace());
        String suppDir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        return Objects.requireNonNull(Paths.get(suppDir, SUPP_FOLDER, STATE_SYSTEM_FOLDER));
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        Path suppFolder = this.getStateSystemFolder();
        if (Files.exists(suppFolder, new LinkOption[0])) {
            try {
                Files.walkFileTree(suppFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, @Nullable BasicFileAttributes attrs) throws IOException {
                        try {
                            String ssid = String.valueOf(file.getFileName());
                            IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendExistingFile((String)ssid, (File)Objects.requireNonNull(file.toFile()), (int)1);
                            ITmfStateSystemBuilder stateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend, (boolean)false);
                            TmfScriptAnalysis.this.fStateSystems.put(ssid, (ITmfStateSystem)stateSystem);
                        }
                        catch (IOException e) {
                            Activator.getInstance().logWarning("Error opening a file that should contain a state system: " + file.getFileName(), (Throwable)e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Activator.getInstance().logWarning("Uncaught error opening state system files", (Throwable)e);
            }
        }
        return true;
    }

    protected void canceling() {
    }

    public @Nullable ITmfStateSystem getStateSystem(String id) {
        return this.fStateSystems.get(id);
    }

    public @Nullable ITmfStateSystem getStateSystem(String id, boolean useExisting) {
        ITmfStateSystem ss = this.fStateSystems.get(id);
        if (ss != null && useExisting) {
            return ss;
        }
        try {
            ITmfTrace trace = Objects.requireNonNull(this.getTrace());
            Path ssFolder = this.getStateSystemFolder();
            Files.createDirectories(ssFolder, new FileAttribute[0]);
            Path ssFile = Paths.get(ssFolder.toString(), id);
            IStateHistoryBackend backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)id, (File)Objects.requireNonNull(ssFile.toFile()), (int)1, (long)trace.getStartTime().toNanos(), (int)10000);
            ITmfStateSystemBuilder stateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            this.fStateSystems.put(id, (ITmfStateSystem)stateSystem);
            return stateSystem;
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error creating the state system", (Throwable)e);
            return ss;
        }
    }

    public Iterable<ITmfStateSystem> getStateSystems() {
        return this.fStateSystems.values();
    }

    public boolean waitForInitialization() {
        return this.waitForCompletion();
    }
}

