/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmCallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmMetadataStateProvider;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.HostThreadIdentifier;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class ApiEventHandler
extends AbstractGpuEventHandler {
    public ApiEventHandler(RocmCallStackStateProvider stateProvider) {
        super(stateProvider);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) throws AttributeNotFoundException {
        Integer tid;
        int systemQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "System"});
        Long threadId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"tid"});
        if (threadId == null) {
            threadId = 0L;
        }
        int threadQuark = ssb.getQuarkRelativeAndAdd(systemQuark, new String[]{"Thread " + threadId.toString()});
        int apiQuark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{event.getName().toUpperCase()});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(apiQuark, new String[]{"CallStack"});
        ITmfEventField content = event.getContent();
        Long timestamp = event.getTimestamp().toNanos();
        Integer functionID = RocmMetadataStateProvider.getFunctionId(event);
        ssb.pushAttribute(timestamp.longValue(), (Object)functionID, callStackQuark);
        Long timestampEnd = (Long)content.getFieldValue(Long.class, new String[]{"end"});
        if (timestampEnd != null) {
            this.fStateProvider.addFutureEvent(((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue()), timestampEnd, callStackQuark, ITmfStateProvider.FutureEventType.POP);
        }
        if ((tid = (Integer)content.getFieldValue(Integer.class, new String[]{"tid"})) == null) {
            return;
        }
        HostThreadIdentifier hostThreadIdentifier = new HostThreadIdentifier(event, tid);
        this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), hostThreadIdentifier, callStackQuark);
    }

    public static String getArg(ITmfEventField content, int argPosition) {
        String args = (String)content.getFieldValue(String.class, new String[]{"args"});
        if (args == null) {
            return "";
        }
        int currentIndex = 0;
        int argIndex = -1;
        int currentPosition = 0;
        int depth = 0;
        while (currentIndex < args.length() && currentPosition <= argPosition) {
            if (args.charAt(currentIndex) == ',' && depth == 0) {
                ++currentPosition;
            }
            if (args.charAt(currentIndex) == '(' || args.charAt(currentIndex) == '{' || args.charAt(currentIndex) == '<') {
                ++depth;
            }
            if (args.charAt(currentIndex) == ')' || args.charAt(currentIndex) == '}' || args.charAt(currentIndex) == '>') {
                --depth;
            }
            if (currentPosition == argPosition && argIndex < 0) {
                argIndex = argPosition > 0 ? currentIndex + 1 : currentIndex;
            }
            ++currentIndex;
        }
        if (currentPosition > argPosition) {
            --currentIndex;
        }
        if (argIndex >= 0) {
            return args.substring(argIndex, currentIndex).strip();
        }
        return "";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static String getFunctionApiName(ITmfEvent event) {
        @NonNull Collection providers = SymbolProviderManager.getInstance().getSymbolProviders(event.getTrace());
        return SymbolProviderUtils.getSymbolText((Collection)providers, (long)RocmMetadataStateProvider.getFunctionId(event));
    }
}

