/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;

public class BinaryFTraceLocationInfo
implements Comparable<BinaryFTraceLocationInfo> {
    private static final Comparator<BinaryFTraceLocationInfo> COMPARATOR = Comparator.comparing(BinaryFTraceLocationInfo::getTimestamp).thenComparing(BinaryFTraceLocationInfo::getIndex);
    private final long fTimestamp;
    private final long fIndex;

    public BinaryFTraceLocationInfo(long ts, long index) {
        this.fTimestamp = ts;
        this.fIndex = index;
    }

    public BinaryFTraceLocationInfo(ByteBuffer bufferIn) {
        this.fTimestamp = bufferIn.getLong();
        this.fIndex = bufferIn.getLong();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public long getIndex() {
        return this.fIndex;
    }

    public int hashCode() {
        return Objects.hash(this.getIndex(), this.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinaryFTraceLocationInfo)) {
            return false;
        }
        BinaryFTraceLocationInfo other = (BinaryFTraceLocationInfo)obj;
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    public String toString() {
        return "Element [" + this.fTimestamp + '/' + this.fIndex + ']';
    }

    @Override
    public int compareTo(BinaryFTraceLocationInfo other) {
        return COMPARATOR.compare(this, other);
    }

    public void serialize(ByteBuffer bufferOut) {
        bufferOut.putLong(this.fTimestamp);
        bufferOut.putLong(this.fIndex);
    }
}

