/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.ui.DebugWCManager;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.BreakpointLocationFinder;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    void toggleLineBreakpoint(final IWorkbenchPart part, ITextSelection selection, final IJavaScriptElement element, final int linenumber) {
        Job job = new Job("Toggle Line Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ITextEditor editor = ToggleBreakpointAdapter.this.getTextEditor(part);
                    if (editor != null && part instanceof IEditorPart) {
                        if (element == null) {
                            ToggleBreakpointAdapter.this.reportToStatusLine(part, Messages.failed_line_bp_no_element);
                            return Status.CANCEL_STATUS;
                        }
                        IResource resource = element.getResource();
                        if (resource == null) {
                            ToggleBreakpointAdapter.this.reportToStatusLine(part, NLS.bind((String)Messages.failed_line_bp_no_resource, (Object)element.getElementName()));
                            return Status.CANCEL_STATUS;
                        }
                        IBreakpoint bp = ToggleBreakpointAdapter.this.lineBreakpointExists(resource, linenumber);
                        if (bp != null) {
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(bp, true);
                            return Status.OK_STATUS;
                        }
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                        int charstart = -1;
                        int charend = -1;
                        try {
                            IRegion line = document.getLineInformation(linenumber - 1);
                            charstart = line.getOffset();
                            charend = charstart + line.getLength();
                        }
                        catch (BadLocationException badLocationException) {}
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("org.eclipse.wst.jsdt.debug.core.type_name", ToggleBreakpointAdapter.this.getTypeName(element));
                        attributes.put("org.eclipse.wst.jsdt.debug.core.script_path", ToggleBreakpointAdapter.this.getScriptPath(element));
                        attributes.put("org.eclipse.wst.jsdt.debug.core.handle", element.getHandleIdentifier());
                        JavaScriptDebugModel.createLineBreakpoint((IResource)resource, (int)linenumber, (int)charstart, (int)charend, attributes, (boolean)true);
                        return Status.OK_STATUS;
                    }
                    ToggleBreakpointAdapter.this.reportToStatusLine(part, Messages.failed_to_create_line_bp);
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    void addBreakpoint(IResource resource, IDocument document, int linenumber) throws CoreException {
        IBreakpoint bp = this.lineBreakpointExists(resource, linenumber);
        if (bp != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(bp, true);
        }
        int charstart = -1;
        int charend = -1;
        try {
            IRegion line = document.getLineInformation(linenumber - 1);
            charstart = line.getOffset();
            charend = charstart + line.getLength();
        }
        catch (BadLocationException badLocationException) {}
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("org.eclipse.wst.jsdt.debug.core.type_name", null);
        attributes.put("org.eclipse.wst.jsdt.debug.core.script_path", resource.getFullPath().makeAbsolute().toString());
        attributes.put("org.eclipse.wst.jsdt.debug.core.handle", null);
        JavaScriptDebugModel.createLineBreakpoint((IResource)resource, (int)linenumber, (int)charstart, (int)charend, attributes, (boolean)true);
    }

    String getScriptPath(IJavaScriptElement element) {
        IPath path = element.getPath();
        return path.makeAbsolute().toString();
    }

    String getTypeName(IJavaScriptElement element) {
        switch (element.getElementType()) {
            case 7: {
                return ((IType)element).getFullyQualifiedName();
            }
            case 8: 
            case 9: {
                IMember member = (IMember)element;
                IType type = member.getDeclaringType();
                if (type == null) break;
                return type.getFullyQualifiedName();
            }
        }
        return null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IDocument document;
        if (!(part instanceof IEditorPart) || !(selection instanceof ITextSelection)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)part.getAdapter(ITextEditor.class);
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            try {
                int lineNumber = document.getLineOfOffset(((ITextSelection)selection).getOffset());
                this.addBreakpoint(this.getResource((IEditorPart)part), document, lineNumber + 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    IType resolveType(IJavaScriptElement element) {
        switch (element.getElementType()) {
            case 7: {
                return (IType)element;
            }
            case 8: 
            case 9: {
                IMember member = (IMember)element;
                IType type = member.getDeclaringType();
                if (type == null) {
                    ITypeRoot root = (ITypeRoot)member.getParent();
                    type = root.findPrimaryType();
                }
                return type;
            }
        }
        if (element instanceof ITypeRoot) {
            return ((ITypeRoot)element).findPrimaryType();
        }
        return null;
    }

    JavaScriptUnit parse(IDocument doc, int offset) {
        try {
            ITypedRegion region = doc.getPartition(offset);
            if (region != null) {
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(doc.get(offset, region.getLength()).toCharArray());
                return (JavaScriptUnit)parser.createAST(null);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    IResource getBreakpointResource(IJavaScriptElement element) {
        IResource res = element.getResource();
        if (res == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!res.getProject().exists()) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        return res;
    }

    ITypeRoot getTypeRoot(IEditorInput input) {
        ITypeRoot root = (ITypeRoot)input.getAdapter(IClassFile.class);
        if (root == null) {
            root = DebugWCManager.getCompilationUnit(input, false);
        }
        return root;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    void toggleMethodBreakpoint(final IWorkbenchPart part, final IJavaScriptElement element, final int line) {
        Job job = new Job("Toggle Function Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (element == null) {
                        ToggleBreakpointAdapter.this.reportToStatusLine(part, Messages.failed_function_bp_no_element);
                        return Status.CANCEL_STATUS;
                    }
                    if (element.getElementType() == 9) {
                        IFunction method = (IFunction)element;
                        IResource resource = element.getResource();
                        if (resource == null) {
                            ToggleBreakpointAdapter.this.reportToStatusLine(part, NLS.bind((String)Messages.failed_function_bp_no_resource, (Object)element.getElementName()));
                            return Status.CANCEL_STATUS;
                        }
                        IBreakpoint bp = ToggleBreakpointAdapter.this.methodBreakpointExists(resource, method.getElementName(), method.getSignature());
                        if (bp != null) {
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(bp, true);
                            return Status.OK_STATUS;
                        }
                        ISourceRange range = method.getNameRange();
                        int start = -1;
                        int end = -1;
                        if (range != null) {
                            start = range.getOffset();
                            end = start + range.getLength();
                        }
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put("org.eclipse.wst.jsdt.debug.core.type_name", ToggleBreakpointAdapter.this.getTypeName(element));
                        attributes.put("org.eclipse.wst.jsdt.debug.core.script_path", ToggleBreakpointAdapter.this.getScriptPath(element));
                        attributes.put("lineNumber", line);
                        IJavaScriptFunctionBreakpoint breakpoint = JavaScriptDebugModel.createFunctionBreakpoint((IResource)resource, (String)method.getElementName(), (String)method.getSignature(), (int)start, (int)end, attributes, (boolean)true);
                        breakpoint.setJavaScriptElementHandle(element.getHandleIdentifier());
                        return Status.OK_STATUS;
                    }
                    ToggleBreakpointAdapter.this.reportToStatusLine(part, Messages.failed_to_create_function_bp);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    void reportToStatusLine(final IWorkbenchPart part, final String message) {
        this.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
            }
        });
    }

    Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextEditor textEditor = this.getTextEditor(part);
            if (textEditor == null) {
                this.reportToStatusLine(part, Messages.no_editor_could_be_found);
                return;
            }
            ITypeRoot root = this.getTypeRoot(textEditor.getEditorInput());
            if (root instanceof IJavaScriptUnit) {
                IJavaScriptUnit unit;
                IJavaScriptUnit iJavaScriptUnit = unit = (IJavaScriptUnit)root;
                synchronized (iJavaScriptUnit) {
                    unit.reconcile(0, false, null, null);
                }
            }
            if (root == null) {
                this.reportToStatusLine(part, Messages.type_root_could_not_be_computed);
                return;
            }
            JavaScriptUnit jsunit = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)root, ASTProvider.WAIT_YES, null);
            BreakpointLocationFinder finder = new BreakpointLocationFinder(jsunit, ((TextSelection)selection).getStartLine() + 1, false);
            jsunit.accept((ASTVisitor)finder);
            switch (finder.getLocation()) {
                case -1: {
                    this.reportToStatusLine(part, Messages.no_valid_location);
                    return;
                }
                case 0: {
                    IJavaScriptElement element = root.getElementAt(finder.getOffset());
                    if (element == null) {
                        element = root;
                    }
                    this.toggleLineBreakpoint(part, (ITextSelection)selection, element, finder.getLineNumber());
                    return;
                }
                case 1: {
                    this.toggleMethodBreakpoint(part, root.getElementAt(finder.getOffset()), finder.getLineNumber());
                    return;
                }
            }
        } else {
            IMember member;
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object o = ss.getFirstElement();
            if (o instanceof IMember && (member = (IMember)o).getElementType() == 9) {
                this.toggleMethodBreakpoint(part, (IJavaScriptElement)member, -1);
            }
        }
    }

    IBreakpoint lineBreakpointExists(IResource resource, int linenumber) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        IJavaScriptLineBreakpoint breakpoint = null;
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof IJavaScriptLineBreakpoint) {
                breakpoint = (IJavaScriptLineBreakpoint)breakpoints[i];
                try {
                    if ("org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker".equals(breakpoint.getMarker().getType()) && resource.equals((Object)breakpoint.getMarker().getResource()) && linenumber == breakpoint.getLineNumber()) {
                        return breakpoint;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    IBreakpoint methodBreakpointExists(IResource resource, String name, String signature) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        IJavaScriptBreakpoint breakpoint = null;
        int i = 0;
        while (i < breakpoints.length) {
            breakpoint = (IJavaScriptBreakpoint)breakpoints[i];
            try {
                if ("org.eclipse.wst.jsdt.debug.core.function.breakpoint.marker".equals(breakpoint.getMarker().getType()) && resource.equals((Object)breakpoint.getMarker().getResource()) && name.equals(breakpoint.getMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.function_name")) && signature.equals(breakpoint.getMarker().getAttribute("org.eclipse.wst.jsdt.debug.core.function_signature"))) {
                    return breakpoint;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

