/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public interface Attributes {
    public static final String CPUS = "CPUs";
    public static final String THREADS = "Threads";
    public static final String CURRENT_THREAD = "Current_thread";
    public static final String SOFT_IRQS = "Soft_IRQs";
    public static final String IRQS = "IRQs";
    public static final String CURRENT_FREQUENCY = "Frequency";
    public static final String MIN_FREQUENCY = "Min frequency";
    public static final String MAX_FREQUENCY = "Max frequency";
    public static final String CURRENT_CPU_RQ = "Current_cpu_rq";
    public static final String PPID = "PPID";
    public static final String PID = "PID";
    public static final String EXEC_NAME = "Exec_name";
    public static final String PRIO = "Prio";
    public static final String SYSTEM_CALL = "System_call";
    public static final String UNKNOWN = "Unknown";
    public static final String THREAD_0_PREFIX = "0_";
    public static final String THREAD_0_SEPARATOR = "_";

    public static @Nullable String buildThreadAttributeName(int threadId, @Nullable Integer cpuId) {
        if (threadId == 0) {
            if (cpuId == null) {
                return null;
            }
            return THREAD_0_PREFIX + String.valueOf(cpuId);
        }
        return String.valueOf(threadId);
    }

    public static Pair<Integer, Integer> parseThreadAttributeName(String threadAttributeName) {
        Integer threadId = -1;
        Integer cpuId = -1;
        try {
            if (threadAttributeName.startsWith(THREAD_0_PREFIX)) {
                threadId = 0;
                String[] tokens = threadAttributeName.split(THREAD_0_SEPARATOR);
                cpuId = Integer.parseInt(tokens[1]);
            } else {
                threadId = Integer.parseInt(threadAttributeName);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return new Pair((Object)threadId, (Object)cpuId);
    }
}

