/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index.export;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.filtermatchers.AbstractFileInfoMatcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ExportIndexFileInfoMatcher
extends AbstractFileInfoMatcher {
    public static String ID = "org.eclipse.cdt.core.exportIndexFileInfoMatcher";
    private IProject project;
    private IPath excludedFolder;

    public static FileInfoMatcherDescription getDescription(String excludePath) {
        return new FileInfoMatcherDescription(ID, (Object)excludePath);
    }

    public boolean matches(IContainer parent, IFileInfo fileInfo) throws CoreException {
        if (this.excludedFolder == null || this.project == null) {
            return false;
        }
        if (!this.project.equals((Object)parent.getProject())) {
            return false;
        }
        IPath testPath = parent.getFullPath().removeFirstSegments(2).append(fileInfo.getName());
        boolean matches = this.excludedFolder.isPrefixOf(testPath);
        if (matches) {
            System.out.println("Filtering: " + String.valueOf(testPath));
        }
        return matches;
    }

    public void initialize(IProject project, Object arguments) throws CoreException {
        this.project = project;
        if (arguments instanceof String) {
            this.excludedFolder = new Path((String)arguments);
        }
    }
}

