/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.analysis.TmfAnalysisModuleSources;
import org.eclipse.tracecompass.internal.tmf.core.analysis.TmfAnalysisParameterProviders;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisParameterProvider;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.analysis.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisModuleOutputs;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public class TmfAnalysisManager {
    private static final Multimap<String, IAnalysisModuleHelper> fAnalysisModules = HashMultimap.create();
    private static final Map<String, List<Class<? extends IAnalysisParameterProvider>>> fParameterProviders = new HashMap<String, List<Class<? extends IAnalysisParameterProvider>>>();
    private static final Map<Class<? extends IAnalysisParameterProvider>, IAnalysisParameterProvider> fParamProviderInstances = new HashMap<Class<? extends IAnalysisParameterProvider>, IAnalysisParameterProvider>();
    private static final List<IAnalysisModuleSource> fSources = new ArrayList<IAnalysisModuleSource>();
    private static final List<ITmfNewAnalysisModuleListener> fListeners = new ArrayList<ITmfNewAnalysisModuleListener>();

    private TmfAnalysisManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        TmfAnalysisParameterProviders.dispose();
        Map<String, List<Class<? extends IAnalysisParameterProvider>>> map = fParameterProviders;
        synchronized (map) {
            fParamProviderInstances.values().forEach(provider -> provider.dispose());
        }
    }

    public static synchronized void registerModuleSource(IAnalysisModuleSource source) {
        fSources.add(source);
        TmfAnalysisManager.refreshModules();
    }

    public static synchronized void deregisterModuleSource(IAnalysisModuleSource source) {
        fSources.remove(source);
        TmfAnalysisManager.refreshModules();
    }

    public static synchronized void initialize() {
        fSources.clear();
        fListeners.clear();
        TmfAnalysisManager.initializeModuleSources();
        TmfAnalysisManager.initializeNewModuleListeners();
    }

    private static synchronized void initializeModuleSources() {
        for (IAnalysisModuleSource source : TmfAnalysisModuleSources.getSources()) {
            fSources.add(source);
        }
    }

    private static synchronized void initializeNewModuleListeners() {
        for (ITmfNewAnalysisModuleListener output : TmfAnalysisModuleOutputs.getOutputListeners()) {
            fListeners.add(output);
        }
    }

    public static synchronized void addNewModuleListener(ITmfNewAnalysisModuleListener listener) {
        fListeners.add(listener);
    }

    public static synchronized Multimap<String, IAnalysisModuleHelper> getAnalysisModules() {
        if (fAnalysisModules.isEmpty()) {
            for (IAnalysisModuleSource source : fSources) {
                for (IAnalysisModuleHelper helper : source.getAnalysisModules()) {
                    fAnalysisModules.put((Object)helper.getId(), (Object)helper);
                }
            }
        }
        return (Multimap)NonNullUtils.checkNotNull((Object)ImmutableMultimap.copyOf(fAnalysisModules));
    }

    public static Map<String, IAnalysisModuleHelper> getAnalysisModules(Class<? extends ITmfTrace> traceclass) {
        Multimap<String, IAnalysisModuleHelper> allModules = TmfAnalysisManager.getAnalysisModules();
        HashMap<String, IAnalysisModuleHelper> map = new HashMap<String, IAnalysisModuleHelper>();
        for (IAnalysisModuleHelper module : allModules.values()) {
            if (!module.appliesToTraceType(traceclass)) continue;
            map.put(module.getId(), module);
        }
        return ImmutableMap.copyOf(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParameterProvider(String analysisId, Class<? extends IAnalysisParameterProvider> paramProvider) {
        Map<String, List<Class<? extends IAnalysisParameterProvider>>> map = fParameterProviders;
        synchronized (map) {
            if (!fParameterProviders.containsKey(analysisId)) {
                fParameterProviders.put(analysisId, new ArrayList());
            }
            ((List)NonNullUtils.checkNotNull(fParameterProviders.get(analysisId))).add(paramProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IAnalysisParameterProvider> getParameterProvidersForModule(IAnalysisModule module, ITmfTrace trace) {
        Set<IAnalysisParameterProvider> providerSet = TmfAnalysisParameterProviders.getParameterProvidersFor(module.getId());
        Map<String, List<Class<? extends IAnalysisParameterProvider>>> map = fParameterProviders;
        synchronized (map) {
            if (!fParameterProviders.containsKey(module.getId())) {
                return providerSet;
            }
            List parameterProviders = (List)NonNullUtils.checkNotNull(fParameterProviders.get(module.getId()));
            for (Class providerClass : parameterProviders) {
                try {
                    @Nullable IAnalysisParameterProvider provider = fParamProviderInstances.get(providerClass);
                    if (provider == null) {
                        provider = (IAnalysisParameterProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        fParamProviderInstances.put(providerClass, provider);
                    }
                    if (!provider.appliesToTrace(trace)) continue;
                    providerSet.add(provider);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Activator.logError(Messages.TmfAnalysisManager_ErrorParameterProvider, e);
                }
            }
        }
        return Collections.unmodifiableSet(providerSet);
    }

    public static synchronized void refreshModules() {
        fAnalysisModules.clear();
    }

    public static synchronized void analysisModuleCreated(IAnalysisModule module) {
        for (ITmfNewAnalysisModuleListener listener : fListeners) {
            listener.moduleCreated(module);
        }
    }
}

