/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTableDataProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentDurationAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentEndTimeAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentStartNsTimeAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreTableDataProvider
extends AbstractTmfTableDataProvider
implements ITmfVirtualTableDataProvider<TmfTreeDataModel, VirtualTableLine> {
    public static final String ID = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreTableDataProvider";
    private static BiMap<ISegmentAspect, Long> fAspectToIdMap = HashBiMap.create();
    private static final Format FORMATTER = new DecimalFormat("###,###.##");
    private static final int STEP = 1000;
    private static final Logger LOGGER = TraceCompassLog.getLogger(SegmentStoreTableDataProvider.class);
    private static final String TABLE_COMPARATOR_EXPRESSION_KEY = "table_comparator_expression";
    private Map<Long, SegmentIndexesComparatorWrapper> fAllIndexes;
    private SegmentIndexesComparatorWrapper fDefaultWrapper;
    private final String fId;
    private ISegmentStoreProvider fSegmentProvider;
    private boolean fIsFirstAspect;
    private int fSegmentStoreSize;

    public SegmentStoreTableDataProvider(ITmfTrace trace, ISegmentStoreProvider segmentProvider, String analysisId) {
        super(trace);
        TraceCompassLogUtils.traceObjectCreation((Logger)LOGGER, (Level)Level.FINE, (Object)((Object)this));
        this.fId = analysisId;
        this.fIsFirstAspect = true;
        this.fAllIndexes = new HashMap<Long, SegmentIndexesComparatorWrapper>();
        this.fDefaultWrapper = new SegmentIndexesComparatorWrapper();
        this.fSegmentProvider = segmentProvider;
    }

    public void dispose() {
        TraceCompassLogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINE, (Object)((Object)this), (int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex(long id, Comparator<ISegment> comparator, String aspectName) {
        if (this.fAllIndexes.containsKey(id)) {
            return;
        }
        ISegmentStore<ISegment> segStore = this.fSegmentProvider.getSegmentStore();
        if (segStore != null) {
            Map<Long, SegmentIndexesComparatorWrapper> map = this.fAllIndexes;
            synchronized (map) {
                block21: {
                    try {
                        try {
                            Throwable throwable = null;
                            Object var8_9 = null;
                            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "SegmentStoreTableDataProvider#buildIndex.buildingIndexes", new Object[0]).build();){
                                TraceCompassLogUtils.traceObjectCreation((Logger)LOGGER, (Level)Level.FINE, this.fAllIndexes);
                                Iterable sortedSegmentStore = segStore.iterator(comparator);
                                List<SegmentStoreIndex> indexes = SegmentStoreTableDataProvider.getIndexes(sortedSegmentStore);
                                if (this.fIsFirstAspect) {
                                    this.fDefaultWrapper = new SegmentIndexesComparatorWrapper(indexes, comparator, aspectName);
                                    this.fIsFirstAspect = false;
                                    this.fAllIndexes.put(id, this.fDefaultWrapper);
                                } else {
                                    this.fAllIndexes.put(id, new SegmentIndexesComparatorWrapper(indexes, comparator, aspectName));
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.SEVERE, (String)"error build index", (Object[])new Object[]{ex.getMessage()});
                            TraceCompassLogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINE, this.fAllIndexes);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        TraceCompassLogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINE, this.fAllIndexes);
                        throw throwable;
                    }
                    TraceCompassLogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINE, this.fAllIndexes);
                }
            }
        }
    }

    private static List<SegmentStoreIndex> getIndexes(Iterable<ISegment> segmentStore) {
        long counter = 0L;
        long i = 0L;
        long previousTimestamp = Long.MAX_VALUE;
        ArrayList<SegmentStoreIndex> indexes = new ArrayList<SegmentStoreIndex>();
        for (ISegment segment : segmentStore) {
            if (segment.getStart() == previousTimestamp) {
                ++counter;
            } else {
                previousTimestamp = segment.getStart();
                counter = 0L;
            }
            if (i % 1000L == 0L) {
                indexes.add(new SegmentStoreIndex(segment.getStart(), counter, segment.getLength()));
            }
            ++i;
        }
        return indexes;
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Comparator<ISegment> comparator;
        long id;
        BiMap<ISegmentAspect, Long> biMap;
        ISegmentAspect aspect2;
        if (this.fSegmentProvider instanceof IAnalysisModule) {
            ((IAnalysisModule)this.fSegmentProvider).waitForCompletion();
            ISegmentStore<ISegment> segmentStore = this.fSegmentProvider.getSegmentStore();
            this.fSegmentStoreSize = segmentStore != null ? segmentStore.size() : 0;
        }
        ArrayList<TmfTreeDataModel> model = new ArrayList<TmfTreeDataModel>();
        for (ISegmentAspect aspect2 : ISegmentStoreProvider.getBaseSegmentAspects()) {
            biMap = fAspectToIdMap;
            synchronized (biMap) {
                id = (Long)fAspectToIdMap.computeIfAbsent((Object)aspect2, a -> SegmentStoreTableDataProvider.createColumnId());
                comparator = aspect2.getComparator();
                if (comparator != null && aspect2.getName().equals(SegmentEndTimeAspect.SEGMENT_END_TIME_ASPECT.getName())) {
                    comparator = comparator.reversed();
                }
                if (comparator != null) {
                    this.buildIndex(id, comparator, aspect2.getName());
                }
                model.add(new TmfTreeDataModel(id, -1L, Collections.singletonList(aspect2.getName()), aspect2.getDataType()));
            }
        }
        for (ISegmentAspect aspect2 : this.fSegmentProvider.getSegmentAspects()) {
            biMap = fAspectToIdMap;
            synchronized (biMap) {
                id = (Long)fAspectToIdMap.computeIfAbsent((Object)aspect2, a -> SegmentStoreTableDataProvider.createColumnId());
                comparator = aspect2.getComparator();
                if (comparator != null) {
                    this.buildIndex(id, comparator, aspect2.getName());
                }
                model.add(new TmfTreeDataModel(id, -1L, Collections.singletonList(aspect2.getName()), aspect2.getDataType()));
            }
        }
        aspect2 = SegmentStartNsTimeAspect.SEGMENT_START_NS_TIME_ASPECT;
        Iterator<ISegmentAspect> iterator = fAspectToIdMap;
        synchronized (iterator) {
            long id2 = (Long)fAspectToIdMap.computeIfAbsent((Object)aspect2, a -> SegmentStoreTableDataProvider.createColumnId());
            Comparator comparator2 = aspect2.getComparator();
            if (comparator2 != null && aspect2.getName().equals(SegmentEndTimeAspect.SEGMENT_END_TIME_ASPECT.getName())) {
                comparator2 = comparator2.reversed();
            }
            if (comparator2 != null) {
                this.buildIndex(id2, comparator2, aspect2.getName());
            }
            model.add(new TmfTreeDataModel(id2, -1L, Collections.singletonList(aspect2.getName())));
        }
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), model), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Exception decompiling
     */
    public TmfModelResponse<ITmfVirtualTableModel<VirtualTableLine>> fetchLines(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TmfModelResponse<ITmfVirtualTableModel<VirtualTableLine>> extractRequestedLines(VirtualTableQueryFilter queryFilter, Map<String, Object> fetchParameters, ISegmentStore<ISegment> segmentStore, Map<Long, ISegmentAspect> aspects, SegmentIndexesComparatorWrapper indexesComparatorWrapper) {
        ArrayList<Long> columnIds = new ArrayList<Long>(aspects.keySet());
        ArrayList<VirtualTableLine> lines = new ArrayList<VirtualTableLine>();
        int startIndexRank = (int)(queryFilter.getIndex() / 1000L);
        int actualStartQueryIndex = (int)(queryFilter.getIndex() % 1000L);
        SegmentStoreIndex segIndex = indexesComparatorWrapper.getIndex(startIndexRank);
        SegmentPredicate filter = new SegmentPredicate(segIndex, indexesComparatorWrapper.getAspectName());
        long start = segIndex.getStartTimestamp();
        int endIndexRank = (int)((queryFilter.getIndex() + (long)queryFilter.getCount() + 1000L - 1L) / 1000L);
        long end = SegmentStoreTableDataProvider.getEndTimestamp(endIndexRank, indexesComparatorWrapper);
        VirtualTableQueryFilter localQueryFilter = queryFilter;
        @Nullable Predicate<ISegment> searchFilter = SegmentStoreTableDataProvider.generateFilter(fetchParameters);
        Object directionValue = fetchParameters.get("table_search_direction");
        if (searchFilter != null && directionValue != null) {
            DataProviderParameterUtils.Direction direction = null;
            try {
                direction = DataProviderParameterUtils.Direction.valueOf((String)String.valueOf(directionValue));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
            }
            WrappedSegment segment = null;
            segment = direction == DataProviderParameterUtils.Direction.NEXT ? SegmentStoreTableDataProvider.getNextWrappedSegmentMatching(searchFilter, startIndexRank, actualStartQueryIndex, segmentStore, indexesComparatorWrapper, lines, aspects, queryFilter.getCount()) : SegmentStoreTableDataProvider.getPreviousWrappedSegmentMatching(searchFilter, startIndexRank, actualStartQueryIndex, segmentStore, indexesComparatorWrapper, lines, aspects, queryFilter.getCount());
            if (segment != null) {
                localQueryFilter = new VirtualTableQueryFilter(queryFilter.getColumnsId(), segment.getRank(), queryFilter.getCount());
                long nextSegmentRank = segment.getRank() + 1L;
                startIndexRank = (int)(nextSegmentRank / 1000L);
                actualStartQueryIndex = (int)(nextSegmentRank % 1000L);
                segIndex = indexesComparatorWrapper.getIndex(startIndexRank);
                start = segIndex.getStartTimestamp();
                endIndexRank = (int)((nextSegmentRank + (long)localQueryFilter.getCount() + 1000L - 1L) / 1000L);
                end = SegmentStoreTableDataProvider.getEndTimestamp(endIndexRank, indexesComparatorWrapper);
            }
            if (queryFilter.getCount() == 1 || segment == null) {
                return new TmfModelResponse((Object)new TmfVirtualTableModel(columnIds, lines, localQueryFilter.getIndex(), (long)segmentStore.size()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
        }
        List newSegStore = segmentStore.getIntersectingElements(start, end, indexesComparatorWrapper.getComparator(), (Predicate)filter);
        int i = actualStartQueryIndex;
        while (i < newSegStore.size()) {
            if (queryFilter.getCount() == lines.size()) break;
            long lineNumber = localQueryFilter.getIndex() + (long)lines.size();
            VirtualTableLine newLine = SegmentStoreTableDataProvider.buildSegmentStoreTableLine(aspects, (ISegment)newSegStore.get(i), lineNumber, searchFilter);
            lines.add(newLine);
            ++i;
        }
        return new TmfModelResponse((Object)new TmfVirtualTableModel(columnIds, lines, localQueryFilter.getIndex(), (long)segmentStore.size()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private SegmentIndexesComparatorWrapper getIndexesComparatorOrDefault(Map<String, Object> fetchParameters) {
        @Nullable Long key = SegmentStoreTableDataProvider.extractColumnId(fetchParameters.get(TABLE_COMPARATOR_EXPRESSION_KEY));
        return this.fAllIndexes.getOrDefault(key, this.fDefaultWrapper);
    }

    private static @Nullable WrappedSegment getNextWrappedSegmentMatching(Predicate<ISegment> searchFilter, int startIndexRank, int startQueryIndex, ISegmentStore<ISegment> segmentStore, SegmentIndexesComparatorWrapper indexesComparatorWrapper, List<VirtualTableLine> lines, Map<Long, ISegmentAspect> aspects, int count) {
        WrappedSegment first = null;
        int startTimeIndexRank = startIndexRank;
        int actualStartQueryIndex = startQueryIndex;
        while (startTimeIndexRank < indexesComparatorWrapper.getIndexesSize()) {
            List<ISegment> segments = SegmentStoreTableDataProvider.getIntersectingElements(segmentStore, indexesComparatorWrapper, startTimeIndexRank);
            int i = actualStartQueryIndex;
            while (i < segments.size()) {
                ISegment segment = segments.get(i);
                if (searchFilter.test(segment)) {
                    long rank = (long)startTimeIndexRank * 1000L + (long)i;
                    WrappedSegment wrapped = new WrappedSegment(segment, rank);
                    lines.add(SegmentStoreTableDataProvider.buildSegmentStoreTableLine(aspects, wrapped.getOriginalSegment(), wrapped.getRank(), searchFilter));
                    WrappedSegment wrappedSegment = first = first == null ? wrapped : first;
                    if (lines.size() == count) {
                        return first;
                    }
                }
                ++i;
            }
            actualStartQueryIndex = 0;
            ++startTimeIndexRank;
        }
        return first;
    }

    private static @Nullable WrappedSegment getPreviousWrappedSegmentMatching(Predicate<ISegment> searchFilter, int startIndexRank, int startQueryIndex, ISegmentStore<ISegment> segmentStore, SegmentIndexesComparatorWrapper indexesComparatorWrapper, List<VirtualTableLine> lines, Map<Long, ISegmentAspect> aspects, int count) {
        WrappedSegment first = null;
        int startTimeIndexRank = startIndexRank;
        int actualStartQueryIndex = startQueryIndex;
        while (startTimeIndexRank >= 0) {
            List<ISegment> segments = SegmentStoreTableDataProvider.getIntersectingElements(segmentStore, indexesComparatorWrapper, startTimeIndexRank);
            int i = Math.min(segments.size() - 1, actualStartQueryIndex);
            while (i >= 0) {
                ISegment segment = segments.get(i);
                if (searchFilter.test(segment)) {
                    long rank = (long)startTimeIndexRank * 1000L + (long)i;
                    WrappedSegment wrapped = new WrappedSegment(segment, rank);
                    lines.add(SegmentStoreTableDataProvider.buildSegmentStoreTableLine(aspects, wrapped.getOriginalSegment(), wrapped.getRank(), searchFilter));
                    WrappedSegment wrappedSegment = first = first == null ? wrapped : first;
                    if (lines.size() == count) {
                        return first;
                    }
                }
                --i;
            }
            actualStartQueryIndex = 1000;
            --startTimeIndexRank;
        }
        return first;
    }

    private static List<ISegment> getIntersectingElements(ISegmentStore<ISegment> segmentStore, SegmentIndexesComparatorWrapper indexesComparatorWrapper, int startTimeIndexRank) {
        int endTimeIndexRank = startTimeIndexRank + 1;
        SegmentStoreIndex segIndex = indexesComparatorWrapper.getIndex(startTimeIndexRank);
        SegmentPredicate filter = new SegmentPredicate(segIndex, indexesComparatorWrapper.getAspectName());
        long end = SegmentStoreTableDataProvider.getEndTimestamp(endTimeIndexRank, indexesComparatorWrapper);
        return segmentStore.getIntersectingElements(segIndex.getStartTimestamp(), end, indexesComparatorWrapper.getComparator(), (Predicate)filter);
    }

    private static @Nullable Predicate<ISegment> generateFilter(Map<String, Object> fetchParameters) {
        @Nullable Map<Long, String> searchMap = SegmentStoreTableDataProvider.extractSearchFilter(fetchParameters);
        if (searchMap == null) {
            return null;
        }
        HashMap<Long, Pattern> patterns = new HashMap<Long, Pattern>();
        for (Map.Entry<Long, String> searchEntry : searchMap.entrySet()) {
            patterns.put(searchEntry.getKey(), Pattern.compile(searchEntry.getValue()));
        }
        BiMap aspects = fAspectToIdMap.inverse();
        return arg_0 -> SegmentStoreTableDataProvider.lambda$3(patterns, (Map)aspects, arg_0);
    }

    private static @Nullable Map<Long, String> extractSearchFilter(Map<String, Object> fetchParameters) {
        Object searchFilterObject = fetchParameters.get("table_search_expressions");
        if (searchFilterObject instanceof Map) {
            return SegmentStoreTableDataProvider.extractSimpleSearchFilter((Map)searchFilterObject);
        }
        return null;
    }

    private static @Nullable Map<Long, String> extractSimpleSearchFilter(Map<?, String> searchFilterObject) {
        if (searchFilterObject.isEmpty()) {
            return null;
        }
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        for (Map.Entry<?, String> searchEntry : searchFilterObject.entrySet()) {
            Long key = SegmentStoreTableDataProvider.extractColumnId(searchEntry.getKey());
            if (key == null) continue;
            searchMap.put(key, searchEntry.getValue());
        }
        return searchMap;
    }

    private static @Nullable Long extractColumnId(@Nullable Object key) {
        return AbstractTmfTableDataProvider.extractColumnId((Object)key, (boolean)true);
    }

    private static VirtualTableLine buildSegmentStoreTableLine(Map<Long, ISegmentAspect> aspects, ISegment segment, long lineNumber, @Nullable Predicate<ISegment> searchFilter) {
        ArrayList<VirtualTableCell> entry = new ArrayList<VirtualTableCell>(aspects.size());
        for (Map.Entry<Long, ISegmentAspect> aspectEntry : aspects.entrySet()) {
            ISegmentAspect aspect = Objects.requireNonNull(aspectEntry.getValue());
            Object aspectResolved = aspect.resolve(segment);
            String cellContent = SegmentStoreTableDataProvider.formatResolvedAspect(aspectResolved, aspect.getName());
            entry.add(new VirtualTableCell(cellContent));
        }
        VirtualTableLine tableLine = new VirtualTableLine(lineNumber, entry);
        if (searchFilter != null) {
            tableLine.setActiveProperties(searchFilter.test(segment) ? 8 : 0);
        }
        return tableLine;
    }

    private Map<Long, ISegmentAspect> getAspectsFromColumnId(List<Long> desiredColumns, @Nullable IProgressMonitor monitor) {
        TmfTreeModel model;
        LinkedHashMap<Long, ISegmentAspect> aspects = new LinkedHashMap<Long, ISegmentAspect>();
        if (!desiredColumns.isEmpty()) {
            for (Long columnId : desiredColumns) {
                ISegmentAspect aspect = (ISegmentAspect)fAspectToIdMap.inverse().get((Object)columnId);
                if (aspect == null) continue;
                aspects.put(columnId, aspect);
            }
            return aspects;
        }
        TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> response = this.fetchTree(Collections.emptyMap(), monitor);
        if (response.getStatus() == ITmfResponse.Status.COMPLETED && (model = (TmfTreeModel)response.getModel()) != null && !model.getEntries().isEmpty()) {
            Collector list = Collectors.toList();
            return this.getAspectsFromColumnId(model.getEntries().stream().map(TmfTreeDataModel::getId).collect(list), monitor);
        }
        return (Map)Objects.requireNonNull(fAspectToIdMap.inverse());
    }

    private static String formatResolvedAspect(@Nullable Object aspectResolved, String aspectName) {
        String aspectParsed = aspectName.equals(TmfStrings.duration()) ? NonNullUtils.nullToEmptyString((Object)FORMATTER.format(aspectResolved)) : (aspectName.equals(TmfStrings.startTime()) || aspectName.equals(TmfStrings.endTime()) ? String.valueOf(TmfTimestamp.fromNanos((long)((Long)Objects.requireNonNull(aspectResolved)))) : (aspectResolved == null ? "" : String.valueOf(aspectResolved)));
        return aspectParsed;
    }

    private static long getEndTimestamp(int position, SegmentIndexesComparatorWrapper indexComparatorWrapper) {
        if (position >= indexComparatorWrapper.getIndexesSize()) {
            boolean isEndTimeComparatorUsed = indexComparatorWrapper.getAspectName().equals(SegmentEndTimeAspect.SEGMENT_END_TIME_ASPECT.getName());
            if (isEndTimeComparatorUsed) {
                return 0L;
            }
            return Long.MAX_VALUE;
        }
        return indexComparatorWrapper.getIndex(position).getStartTimestamp();
    }

    private static /* synthetic */ boolean lambda$3(Map map, Map map2, ISegment segment) {
        for (Map.Entry patternEntry : map.entrySet()) {
            Pattern pattern = Objects.requireNonNull((Pattern)patternEntry.getValue());
            ISegmentAspect aspect = (ISegmentAspect)map2.get(patternEntry.getKey());
            if (aspect == null || pattern.matcher(SegmentStoreTableDataProvider.formatResolvedAspect(aspect.resolve(segment), aspect.getName())).find()) continue;
            return false;
        }
        return true;
    }

    private static final class SegmentIndexesComparatorWrapper {
        private final List<SegmentStoreIndex> fIndexes;
        private final Comparator<ISegment> fComparator;
        private final String fAspectName;

        public SegmentIndexesComparatorWrapper() {
            this.fComparator = SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(Comparator.comparingLong(ISegment::getLength));
            this.fIndexes = new ArrayList<SegmentStoreIndex>();
            this.fAspectName = "";
        }

        public SegmentIndexesComparatorWrapper(List<SegmentStoreIndex> indexes, Comparator<ISegment> comparator, String aspectName) {
            this.fIndexes = indexes;
            this.fComparator = comparator;
            this.fAspectName = aspectName;
        }

        public SegmentStoreIndex getIndex(int rank) {
            return this.fIndexes.get(rank);
        }

        public int getIndexesSize() {
            return this.fIndexes.size();
        }

        public Comparator<ISegment> getComparator() {
            return this.fComparator;
        }

        public String getAspectName() {
            return this.fAspectName;
        }
    }

    private static class SegmentPredicate
    implements Predicate<ISegment> {
        private final long fStartTime;
        private long fCount;
        private long fLength;
        private boolean fDurationComparator;

        public SegmentPredicate(SegmentStoreIndex segmentIndex, String aspectName) {
            this.fStartTime = segmentIndex.getStartTimestamp();
            this.fCount = segmentIndex.getCounter();
            this.fLength = segmentIndex.getLength();
            this.fDurationComparator = aspectName.equals(SegmentDurationAspect.SEGMENT_DURATION_ASPECT.getName());
        }

        @Override
        public boolean test(ISegment segment) {
            if (this.isDurationValid(segment.getLength())) {
                if (segment.getStart() > this.fStartTime) {
                    return true;
                }
                if (segment.getStart() == this.fStartTime) {
                    if (this.fCount == 0L) {
                        return true;
                    }
                    --this.fCount;
                }
            }
            return false;
        }

        private boolean isDurationValid(long segmentLength) {
            if (!this.fDurationComparator) {
                return true;
            }
            return segmentLength == this.fLength;
        }
    }

    private static class SegmentStoreIndex {
        private long fCounter;
        private long fStartTimestamp;
        private long fLength;

        public SegmentStoreIndex(long startTimeStamp, long counter, long length) {
            this.fStartTimestamp = startTimeStamp;
            this.fCounter = counter;
            this.fLength = length;
        }

        public long getStartTimestamp() {
            return this.fStartTimestamp;
        }

        public long getCounter() {
            return this.fCounter;
        }

        public long getLength() {
            return this.fLength;
        }
    }

    private static class WrappedSegment {
        private ISegment fSegment;
        private long fRank;

        public WrappedSegment(ISegment segment, long rank) {
            this.fSegment = segment;
            this.fRank = rank;
        }

        public ISegment getOriginalSegment() {
            return this.fSegment;
        }

        public long getRank() {
            return this.fRank;
        }
    }
}

