/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph.sampled;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.sampled.callgraph.ProfilingCallGraphAnalysisModule;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class SampledCallGraphTest {
    private static final long @NonNull [] CALLSITE_1 = new long[]{1L, 2L, 3L, 4L};
    private static final long @NonNull [] CALLSITE_2 = new long[]{1L, 2L, 3L};
    private static final long @NonNull [] CALLSITE_3 = new long[]{1L, 2L, 3L, 4L};
    private static final long @NonNull [] CALLSITE_4 = new long[]{1L, 3L, 4L};
    private static final long @NonNull [] CALLSITE_5 = new long[]{1L, 2L, 5L};
    private static final long @NonNull [] CALLSITE_6 = new long[]{1L, 2L, 5L, 4L};
    private static final long @NonNull [] CALLSITE_7 = new long[]{10L, 11L, 12L};
    private static final long @NonNull [] CALLSITE_8 = new long[]{10L, 11L};
    private static final long @NonNull [] CALLSITE_9 = new long[]{1L, 2L, 3L, 4L};
    private static final long @NonNull [] CALLSITE_10 = new long[]{1L, 2L, 4L, 5L};

    @Test
    public void testStackTraces() {
        TestProfilingAnalysis pg = new TestProfilingAnalysis();
        try {
            ICallStackElement element = pg.getElement();
            CallGraph cg = pg.getCallGraph();
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_1, 1L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_2, 2L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_3, 3L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_4, 4L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_5, 5L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_6, 6L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_7, 7L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_8, 8L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_9, 9L));
            cg.addAggregatedCallSite(element, pg.getCallSite(element, CALLSITE_10, 10L));
            Collection aggregatedData = cg.getCallingContextTree(element);
            Assert.assertNotNull((Object)aggregatedData);
            Assert.assertEquals((long)2L, (long)aggregatedData.size());
            block19: for (AggregatedCallSite callsite : aggregatedData) {
                switch (CallStackTestBase2.getCallSiteSymbol(callsite).resolve(Collections.emptySet())) {
                    case "0x1": {
                        Assert.assertEquals((long)8L, (long)callsite.getWeight());
                        Assert.assertEquals((long)2L, (long)callsite.getCallees().size());
                        for (AggregatedCallSite childCallsite : callsite.getCallees()) {
                            switch (CallStackTestBase2.getCallSiteSymbol(childCallsite).resolve(Collections.emptySet())) {
                                case "0x2": {
                                    Assert.assertEquals((long)7L, (long)childCallsite.getWeight());
                                    Assert.assertEquals((long)3L, (long)childCallsite.getCallees().size());
                                    break;
                                }
                                case "0x3": {
                                    Assert.assertEquals((long)1L, (long)childCallsite.getWeight());
                                    Assert.assertEquals((long)1L, (long)childCallsite.getCallees().size());
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unknown callsite: " + CallStackTestBase2.getCallSiteSymbol(childCallsite));
                                }
                            }
                        }
                        continue block19;
                    }
                    case "0xa": {
                        AggregatedCallSite childCallsite;
                        Assert.assertEquals((long)2L, (long)callsite.getWeight());
                        Assert.assertEquals((long)1L, (long)callsite.getCallees().size());
                        childCallsite = (AggregatedCallSite)callsite.getCallees().iterator().next();
                        Assert.assertEquals((long)2L, (long)childCallsite.getWeight());
                        Assert.assertEquals((long)1L, (long)callsite.getCallees().size());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown callsite: " + CallStackTestBase2.getCallSiteSymbol(callsite));
                    }
                }
            }
        }
        finally {
            pg.dispose();
        }
    }

    private static class TestProfilingAnalysis
    extends ProfilingCallGraphAnalysisModule {
        private final @NonNull ICallStackElement fOneElement;

        public TestProfilingAnalysis() {
            CallStackElement element = new CallStackElement("test", AllGroupDescriptor.getInstance());
            this.addRootElement((ICallStackElement)element);
            this.fOneElement = element;
        }

        public @NonNull ICallStackElement getElement() {
            return this.fOneElement;
        }

        public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
            return Collections.singleton(AllGroupDescriptor.getInstance());
        }

        public Map<String, Collection<Object>> getCallStack(@NonNull ITmfEvent event) {
            return Collections.emptyMap();
        }

        protected @Nullable Pair<@NonNull ICallStackElement, @NonNull AggregatedCallSite> getProfiledStackTrace(@NonNull ITmfEvent event) {
            return null;
        }
    }
}

