/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint;

import java.io.File;
import org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint.AbstractIndexTest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.junit.Assert;
import org.junit.Test;

public class TmfBTreeIndexTest
extends AbstractIndexTest {
    @Override
    protected AbstractIndexTest.ITestIndexer createTestIndexer(AbstractIndexTest.TestTrace trace) {
        return new TestBTreeIndexer(trace);
    }

    @Test
    public void testReopenIndex() throws Exception {
        fTrace.dispose();
        fTrace = this.createTrace(this.getTracePath());
        Assert.assertFalse((boolean)fTrace.getIndexer().getCheckpoints().isCreatedFromScratch());
        fTrace.indexTrace(true);
        TmfBTreeIndexTest.verifyIndexContent();
    }

    @Test
    public void testInsertAfterReopenIndex() throws Exception {
        fTrace.dispose();
        String directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)fTrace);
        new File(directory + "checkpoint_btree.idx").delete();
        new File(directory + "checkpoint_flatarray.idx").delete();
        this.fNbEventsLimit = 5000L;
        fTrace = this.createTrace(this.getTracePath());
        Assert.assertTrue((boolean)fTrace.getIndexer().getCheckpoints().isCreatedFromScratch());
        Assert.assertEquals((long)this.fNbEventsLimit, (long)fTrace.getNbEvents());
        this.fNbEventsLimit = Long.MAX_VALUE;
        fTrace = this.createTrace(this.getTracePath());
        Assert.assertFalse((boolean)fTrace.getIndexer().getCheckpoints().isCreatedFromScratch());
        TmfBTreeIndexTest.verifyIndexContent();
    }

    private static class TestBTreeIndexer
    extends TmfBTreeTraceIndexer
    implements AbstractIndexTest.ITestIndexer {
        public TestBTreeIndexer(AbstractIndexTest.TestTrace testTrace) {
            super((ITmfTrace)testTrace, 100);
        }

        @Override
        public ITmfCheckpointIndex getCheckpoints() {
            return this.getTraceIndex();
        }
    }
}

