/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class ImageUtil {
    public static final String DEFAULT_ROOT_LINK = "rootLink";
    public static final String DEFAULT_SMALL_ROOT_LINK = "rootLinkSmall";
    public static final String DEFAULT_FORM_BG = "formBg";
    public static final String DEFAULT_LINK = "link";
    public static final String BACK = "back";
    public static final String HELP_TOPIC = "helpTopic";
    public static final String RESTORE_WELCOME = "restoreWelcome";
    public static final String INTRO_MODEL_LEAF = "leaf";
    public static final String INTRO_MODEL_CONTAINER = "container";
    public static final String OPEN_ITNRO_VIEW = "introView";
    public static final String CONFIG_EXTENSION = "configExtension";
    public static final String ICONS_PATH = "$nl$/icons/";

    public static ImageDescriptor createImageDescriptor(String imageName) {
        return ImageUtil.createImageDescriptor(FrameworkUtil.getBundle(ImageUtil.class), ICONS_PATH + imageName);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, String imageName) {
        try {
            URL imageUrl = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)imageName), null);
            if (imageUrl != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageUrl);
                return desc;
            }
        }
        catch (Exception e) {
            Log.error("could not create Image Descriptor", e);
        }
        Log.warning("could not create Image Descriptor for: " + imageName + " in bundle: " + bundle.getSymbolicName());
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static ImageDescriptor createImageDescriptor(IPath base, String imageName) {
        try {
            URL imageUrl = new URL(base.append(imageName).toOSString());
            if (imageUrl != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageUrl);
                return desc;
            }
        }
        catch (Exception e) {
            Log.error("could not create Image Descriptor", e);
        }
        Log.warning("could not create Image Descriptor for: " + imageName);
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static Image createImage(String imageName) {
        try {
            ImageDescriptor imageDsc = ImageUtil.createImageDescriptor(imageName);
            return imageDsc.createImage();
        }
        catch (Exception e) {
            Log.error("could not create Image", e);
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }

    public static Image getImage(String key) {
        return IntroPlugin.getDefault().getVolatileImageRegistry().get(key);
    }

    public static boolean hasImage(String key) {
        ImageRegistry registry = IntroPlugin.getDefault().getVolatileImageRegistry();
        return registry.getDescriptor(key) != null;
    }

    public static void registerImage(String key, String imageName) {
        ImageRegistry registry = IntroPlugin.getDefault().getVolatileImageRegistry();
        if (registry.getDescriptor(key) != null) {
            return;
        }
        registry.put(key, ImageUtil.createImageDescriptor(imageName));
    }

    public static void registerImage(String key, Bundle bundle, String imageName) {
        ImageRegistry registry = IntroPlugin.getDefault().getVolatileImageRegistry();
        if (registry.getDescriptor(key) != null) {
            return;
        }
        registry.put(key, ImageUtil.createImageDescriptor(bundle, imageName));
    }

    public static void registerImage(String key, IPath base, String imageName) {
        ImageRegistry registry = IntroPlugin.getDefault().getVolatileImageRegistry();
        if (registry.getDescriptor(key) != null) {
            return;
        }
        registry.put(key, ImageUtil.createImageDescriptor(base, imageName));
    }
}

