/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;

public abstract class StructuredSelectActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;
    private SelectionHistory fHistory;

    public void dispose() {
        this.fEditor = null;
        this.fHistory = null;
    }

    public void init(IViewPart view) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (this.fEditor instanceof ITextEditor) {
            IndexedRegion cursorIndexedRegion;
            Region newSelectionRegion;
            ITextSelection textSelection;
            ITextEditor textEditor = (ITextEditor)this.fEditor;
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (selection instanceof ITextSelection && document != null && (textSelection = (ITextSelection)selection).getLength() < document.getLength() && (newSelectionRegion = this.getNewSelectionRegion(cursorIndexedRegion = this.getCursorIndexedRegion(document, textSelection), textSelection)) != null) {
                this.fHistory.remember((IRegion)new Region(textSelection.getOffset(), textSelection.getLength()));
                try {
                    this.fHistory.ignoreSelectionChanges();
                    textEditor.selectAndReveal(newSelectionRegion.getOffset(), newSelectionRegion.getLength());
                }
                finally {
                    this.fHistory.listenToSelectionChanges();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
        this.fHistory = this.fEditor != null ? (SelectionHistory)this.fEditor.getAdapter(SelectionHistory.class) : null;
    }

    protected abstract IndexedRegion getCursorIndexedRegion(IDocument var1, ITextSelection var2);

    protected abstract Region getNewSelectionRegion(IndexedRegion var1, ITextSelection var2);

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IndexedRegion getIndexedRegion(IDocument document, int offset) {
        IndexedRegion indexedRegion = null;
        int lastOffset = offset;
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        if (model == null) return indexedRegion;
        try {
            block6: {
                block5: {
                    indexedRegion = model.getIndexedRegion(lastOffset);
                    if (!true) break block5;
                    if (indexedRegion != null) return indexedRegion;
                    if (lastOffset < 0) break block6;
                }
                do {
                    indexedRegion = model.getIndexedRegion(--lastOffset);
                    if (indexedRegion != null) return indexedRegion;
                } while (lastOffset >= 0);
            }
            return indexedRegion;
        }
        finally {
            model.releaseFromRead();
        }
    }
}

