/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.execution.graph;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.execution.graph.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class OsWorker
implements IGraphWorker {
    private final HostThread fHostTid;
    private final long fStart;
    private String fThreadName;
    private ProcessStatus fStatus = ProcessStatus.UNKNOWN;
    private ProcessStatus fOldStatus = ProcessStatus.UNKNOWN;

    public OsWorker(HostThread ht, String name, long ts) {
        this.fHostTid = ht;
        this.fThreadName = name;
        this.fStart = ts;
    }

    public String getHostId() {
        return this.fHostTid.getHost();
    }

    public @NonNull Map<@NonNull String, @NonNull String> getWorkerInformation() {
        int tid = this.fHostTid.getTid();
        if (tid == -1) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(OsStrings.tid(), String.valueOf(tid));
    }

    public @NonNull Map<@NonNull String, @NonNull Object> getWorkerAspects() {
        int tid = this.fHostTid.getTid();
        if (tid == -1) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(OsStrings.tid(), tid);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getWorkerInformation(long t) {
        String execName;
        int tid = this.fHostTid.getTid();
        if (tid == -1) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder workerInfo = new ImmutableMap.Builder();
        workerInfo.put((Object)OsStrings.tid(), (Object)String.valueOf(tid));
        Optional<@Nullable KernelAnalysisModule> kam = TmfTraceManager.getInstance().getActiveTraceSet().stream().filter(trace -> trace.getHostId().equals(this.getHostId())).map(trace -> (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel")).filter(Objects::nonNull).findFirst();
        if (!kam.isPresent()) {
            return workerInfo.build();
        }
        KernelAnalysisModule module = kam.get();
        int priority = KernelThreadInformationProvider.getThreadPriority(module, tid, t);
        if (priority != -1) {
            workerInfo.put((Object)NonNullUtils.nullToEmptyString((Object)Messages.OsWorker_threadPriority), (Object)Integer.toString(priority));
        }
        if ((execName = KernelThreadInformationProvider.getExecutableName(module, tid, t)) != null) {
            workerInfo.put((Object)OsStrings.execName(), (Object)execName);
        }
        return workerInfo.build();
    }

    public void setName(String name) {
        this.fThreadName = name;
    }

    public String getName() {
        return this.fThreadName;
    }

    public void setStatus(ProcessStatus status) {
        this.fOldStatus = this.fStatus;
        this.fStatus = status;
    }

    public ProcessStatus getStatus() {
        return this.fStatus;
    }

    public ProcessStatus getOldStatus() {
        return this.fOldStatus;
    }

    public HostThread getHostThread() {
        return this.fHostTid;
    }

    public long getStart() {
        return this.fStart;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof OsWorker) {
            return this.getHostThread().equals(((OsWorker)obj).getHostThread());
        }
        return false;
    }

    public int hashCode() {
        return this.fHostTid.hashCode();
    }

    public String toString() {
        return "[" + this.fThreadName + "," + String.valueOf(this.fHostTid.getTid()) + "]";
    }
}

